/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.operations.performance;

import nyla.solutions.core.patterns.decorator.TextDecorator;
import nyla.solutions.core.util.stats.MathematicStats;

public class MathematicStatsDecorator
implements TextDecorator<MathematicStats> {
    private final MathematicStats stats;

    public MathematicStatsDecorator(MathematicStats stats) {
        this.stats = stats;
    }

    @Override
    public String getText() {
        return "mean ms" + '\t' + this.toMilliseconds(this.stats.mean()) + '\n' + "min ms" + '\t' + this.toMilliseconds(this.stats.min()) + '\n' + "max ms" + '\t' + this.toMilliseconds(this.stats.max()) + '\n' + "70th ms" + '\t' + this.toMilliseconds(this.stats.percentile(70.0)) + '\n' + "90th ms" + '\t' + this.toMilliseconds(this.stats.percentile(90.0)) + '\n' + "99.9th ms" + '\t' + this.toMilliseconds(this.stats.percentile(99.9)) + '\n' + "99.999th ms" + '\t' + this.toMilliseconds(this.stats.percentile(99.999)) + '\n' + "stddev ms" + '\t' + this.toMilliseconds(this.stats.stdDev());
    }

    protected double toMilliseconds(double nanoseconds) {
        return nanoseconds / 1000000.0;
    }

    @Override
    public MathematicStats getTarget() {
        return null;
    }
}

