/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.operations.performance;

import nyla.solutions.core.operations.performance.BenchMarker;
import nyla.solutions.core.operations.performance.MathematicStatsDecorator;
import nyla.solutions.core.patterns.decorator.TextDecorator;
import nyla.solutions.core.util.stats.MathematicStats;
import nyla.solutions.core.util.stats.Mathematics;

public class PerformanceCheck {
    private final BenchMarker marker;
    private final MathematicStats stats;
    private final TextDecorator<MathematicStats> decorator;

    public PerformanceCheck(BenchMarker marker, MathematicStats stats) {
        this(marker, stats, new MathematicStatsDecorator(stats));
    }

    public PerformanceCheck(BenchMarker marker, MathematicStats stats, TextDecorator<MathematicStats> decorator) {
        this.marker = marker;
        this.stats = stats;
        decorator.setTarget(stats);
        this.decorator = decorator;
    }

    public PerformanceCheck(BenchMarker marker, int capacity) {
        this(marker, new MathematicStats(capacity, new Mathematics()));
    }

    public void perfCheck(Runnable r) {
        try {
            this.marker.measure(r, this.stats);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getReport() {
        return this.decorator.getText();
    }
}

