/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.operations.performance.stats;

import java.time.LocalDateTime;
import java.util.concurrent.atomic.LongAdder;
import nyla.solutions.core.util.Scheduler;

public class ThroughputStatistics {
    private final LongAdder counter = new LongAdder();

    public ThroughputStatistics() {
    }

    public ThroughputStatistics(long increment) {
        this.increment(increment);
    }

    public static double throughPutPerSecond(Iterable<ThroughputStatistics> stats, LocalDateTime start, LocalDateTime end) {
        long count = 0L;
        for (ThroughputStatistics stat : stats) {
            count += stat.count();
        }
        double totalSeconds = Scheduler.durationSeconds(start, end);
        if (totalSeconds == 0.0) {
            return count;
        }
        return (double)count / totalSeconds;
    }

    public void increment() {
        this.counter.increment();
    }

    public long count() {
        return this.counter.longValue();
    }

    public void increment(long l) {
        this.counter.add(l);
    }

    public long throughputPerMs(LocalDateTime start, LocalDateTime end) {
        long ms = Scheduler.durationMS(start, end);
        if (ms == 0L) {
            return this.counter.longValue();
        }
        return this.counter.longValue() / ms;
    }

    public double throughputPerSecond(LocalDateTime start, LocalDateTime end) {
        double secs = Scheduler.durationSeconds(start, end);
        if (secs == 0.0) {
            return this.counter.longValue();
        }
        return (double)this.counter.longValue() / secs;
    }

    public void reset() {
        this.counter.reset();
    }
}

