/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.batch;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import nyla.solutions.core.exception.ConnectionException;
import nyla.solutions.core.exception.RequiredException;
import nyla.solutions.core.patterns.batch.BatchReport;
import nyla.solutions.core.patterns.conversion.Converter;

public class BatchJob<InputType, OutputType> {
    private final Supplier<InputType> supplier;
    private final Consumer<List<OutputType>> consumer;
    private final int batchChunkSize;
    private final Function<InputType, OutputType> processor;

    public BatchJob(Supplier<InputType> supplier, Consumer<List<OutputType>> consumer, int batchChunkSize) {
        this(supplier, consumer, batchChunkSize, (InputType item) -> item);
    }

    public BatchJob(Supplier<InputType> supplier, Consumer<List<OutputType>> consumer, int batchChunkSize, Converter<InputType, OutputType> processor) {
        this.supplier = supplier;
        this.consumer = consumer;
        this.batchChunkSize = batchChunkSize;
        this.processor = input -> processor.convert(input);
    }

    public BatchJob(Supplier<InputType> supplier, Consumer<List<OutputType>> consumer, int batchChunkSize, Function<InputType, OutputType> processor) {
        this.supplier = supplier;
        this.consumer = consumer;
        this.batchChunkSize = batchChunkSize;
        this.processor = processor;
    }

    public static BatchJobBuilder builder() {
        return new BatchJobBuilder();
    }

    public BatchReport execute() {
        InputType item;
        List<InputType> outputList = Collections.synchronizedList(new ArrayList(this.batchChunkSize));
        BatchReport batchReport = new BatchReport();
        batchReport.startTime();
        while ((item = this.supplier.get()) != null) {
            outputList.add(this.processor != null ? this.processor.apply(item) : item);
            batchReport.incrementInput();
            if (outputList.size() < this.batchChunkSize - 1) continue;
            this.consumer.accept(outputList);
            batchReport.incrementOutput(outputList.size());
            outputList.clear();
        }
        if (this.supplier instanceof Closeable) {
            try {
                ((Closeable)((Object)this.supplier)).close();
            }
            catch (IOException e) {
                throw new ConnectionException("Unable to close supplier ERROR:" + e.getMessage(), e);
            }
        }
        if (!outputList.isEmpty()) {
            this.consumer.accept(outputList);
            batchReport.incrementOutput(outputList.size());
        }
        batchReport.endTime();
        if (this.consumer instanceof Closeable) {
            try {
                ((Closeable)((Object)this.consumer)).close();
            }
            catch (IOException e) {
                throw new ConnectionException("Unable to close consumer ERROR:" + e.getMessage(), e);
            }
        }
        return batchReport;
    }

    public static class BatchJobBuilder<InputType, OutputType> {
        private Supplier supplier = null;
        private Consumer<List<OutputType>> consumer = null;
        private int batchChunkSize = 1000;
        private Function<InputType, OutputType> processor = null;

        public BatchJobBuilder supplier(Supplier<InputType> supplier) {
            this.supplier = supplier;
            return this;
        }

        public BatchJobBuilder consumer(Consumer<List<OutputType>> consumer) {
            this.consumer = consumer;
            return this;
        }

        public BatchJobBuilder batchChunkSize(int batchChunkSize) {
            this.batchChunkSize = batchChunkSize;
            return this;
        }

        public BatchJobBuilder processor(Function<InputType, OutputType> processor) {
            this.processor = processor;
            return this;
        }

        public BatchJob build() {
            if (this.consumer == null) {
                throw new RequiredException("consumer is missing");
            }
            if (this.supplier == null) {
                throw new RequiredException("supplier is missing");
            }
            return new BatchJob<InputType, OutputType>(this.supplier, this.consumer, this.batchChunkSize, this.processor);
        }
    }
}

