/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.conversion.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import nyla.solutions.core.exception.NonSerializableException;
import nyla.solutions.core.patterns.conversion.Converter;

public class SerializableToBytesConverter<ObjectType extends Serializable>
implements Converter<ObjectType, byte[]> {
    private int byteSize = 32;

    @Override
    public byte[] convert(ObjectType sourceObject) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.byteSize);
        try {
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(sourceObject);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new NonSerializableException(e);
        }
    }

    public int getByteSize() {
        return this.byteSize;
    }

    public void setByteSize(int byteSize) {
        this.byteSize = byteSize;
    }
}

