/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.conversion.numbers;

import nyla.solutions.core.patterns.conversion.Converter;
import nyla.solutions.core.util.Text;

public class TextToDouble
implements Converter<String, Double> {
    private final Double defaultValue;

    public TextToDouble(Double defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public Double convert(String text) {
        if (text == null || text.isEmpty()) {
            return this.defaultValue;
        }
        return Double.valueOf(text);
    }

    public static double fromObject(Object objectToString, Double defaultValue) {
        return new TextToDouble(defaultValue).convert(Text.toString(objectToString));
    }

    public static double fromObject(Object objectToString, double defaultValue) {
        return new TextToDouble(defaultValue).convert(Text.toString(objectToString));
    }
}

