/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.conversion.numbers;

import nyla.solutions.core.patterns.conversion.Converter;
import nyla.solutions.core.util.Text;

public class TextToLong
implements Converter<String, Long> {
    private static final TextToLong instance = new TextToLong();

    public static Long from(String longText) {
        return instance.convert(longText);
    }

    public static Long from(String longText, long defaultValue) {
        if (longText == null || longText.isEmpty()) {
            return defaultValue;
        }
        return TextToLong.from(longText);
    }

    public static <T> Long fromObject(T fromObject) {
        return TextToLong.from(Text.toString(fromObject));
    }

    public static <T> Long fromObject(T fromObject, Long defaultValue) {
        return TextToLong.from(Text.toString(fromObject), defaultValue);
    }

    @Override
    public Long convert(String longText) {
        if (longText == null || longText.isEmpty()) {
            return null;
        }
        return Long.valueOf(longText);
    }
}

