/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.creational.builder.mapped;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import nyla.solutions.core.exception.NoDataFoundException;
import nyla.solutions.core.io.IO;
import nyla.solutions.core.patterns.creational.builder.mapped.MappedKeyDirector;
import nyla.solutions.core.patterns.creational.builder.mapped.MappedKeyEngineer;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.Debugger;
import nyla.solutions.core.util.Text;

public class FileMappedKeyDirector<K, V>
extends MappedKeyDirector<K, V> {
    private String listPattern = Config.settings().getProperty(this.getClass(), "listPattern", "*.([xX][mM][lL]|[hH][tT][mM][lL]?|txt|TXT|xml|XML)");
    private Set<String> crawledPaths = new HashSet<String>();
    private String ignorePathRegExp = "";

    @Override
    public void constructDocument(String filePath, MappedKeyEngineer<K, V> engineer) {
        try {
            this.crawl(new File(filePath), engineer);
        }
        finally {
            this.crawledPaths.clear();
        }
    }

    protected void crawl(File file, MappedKeyEngineer<K, V> engineer) {
        if (!file.exists()) {
            Debugger.println(file + " does not exist.");
            return;
        }
        if (file.isDirectory()) {
            File[] files = IO.listFiles(file, this.listPattern);
            for (int i = 0; i < files.length; ++i) {
                if (this.mustSkip(files[i])) continue;
                this.crawl(files[i], engineer);
            }
        } else {
            try {
                engineer.construct(file.getPath(), this.constructMapToText(file.getPath()));
                this.crawledPaths.add(file.getPath());
            }
            catch (NoDataFoundException e) {
                Debugger.printWarn(e);
            }
        }
    }

    private boolean mustSkip(File file) {
        String path = file.getPath();
        if (Text.matches(path, this.ignorePathRegExp) || this.crawledPaths.contains(path)) {
            Debugger.println(this, "skipped =" + path);
            return true;
        }
        return false;
    }
}

