/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.creational.generator;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import nyla.solutions.core.patterns.creational.generator.CreatorTextable;

public class DateTextCreator
implements CreatorTextable {
    private final DateTimeFormatter dateTimeFormatter;

    public DateTextCreator(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    public DateTextCreator() {
        this(DateTimeFormatter.ISO_DATE);
    }

    @Override
    public String create() {
        return LocalDate.now().format(this.dateTimeFormatter);
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return this.dateTimeFormatter;
    }
}

