/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.creational.generator;

import java.util.concurrent.atomic.AtomicInteger;
import nyla.solutions.core.exception.RequiredException;
import nyla.solutions.core.patterns.creational.generator.CreatorTextable;

public class FixedNameCreator
implements CreatorTextable {
    private final String[] names;
    private AtomicInteger i = new AtomicInteger(0);

    public FixedNameCreator(String ... names) {
        if (names == null || names.length == 0) {
            throw new RequiredException("At least one name must be provided");
        }
        this.names = names;
    }

    @Override
    public String create() {
        int index = this.i.get();
        if (index >= this.names.length) {
            index = 0;
            this.i.set(index);
        }
        String results = this.names[index];
        this.i.set(++index);
        return results;
    }
}

