/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.creational.generator;

import nyla.solutions.core.patterns.creational.generator.CreatorTextable;
import nyla.solutions.core.util.Digits;

public class IntegerRangeTextCreator
implements CreatorTextable {
    public static final String MIN_INT_TEXT_PROP = "INT_RANGE_TEXT_CREATOR_MIN";
    public static final String MAX_INT_TEXT_PROP = "INT_RANGE_TEXT_CREATOR_MAX";
    private final Digits digits = new Digits();
    private final int min;
    private final int max;

    public IntegerRangeTextCreator(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public IntegerRangeTextCreator() {
        this(1, Integer.MAX_VALUE);
    }

    public static IntegerRangeTextCreator range(int min, int max) {
        return new IntegerRangeTextCreator(min, max);
    }

    @Override
    public String create() {
        return String.valueOf(this.digits.generateInteger(this.min, this.max));
    }
}

