/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.creational.generator.json;

import java.time.format.DateTimeFormatter;
import java.util.Random;
import nyla.solutions.core.data.json.JsonPropertySchema;
import nyla.solutions.core.data.json.JsonPropertyType;
import nyla.solutions.core.patterns.conversion.Converter;
import nyla.solutions.core.patterns.creational.generator.CreatorFactoryByPropertyName;
import nyla.solutions.core.util.Digits;

public class JsonPropertySchemaToJsonPropertyConverter
implements Converter<JsonPropertySchema, String> {
    private Random random = new Random(System.currentTimeMillis());
    private final CreatorFactoryByPropertyName factory;

    public JsonPropertySchemaToJsonPropertyConverter(DateTimeFormatter dateTimeformatter) {
        this.factory = new CreatorFactoryByPropertyName(dateTimeformatter);
    }

    @Override
    public String convert(JsonPropertySchema jsonPropertySchema) {
        if (jsonPropertySchema == null) {
            return null;
        }
        return this.formatPropertyName(jsonPropertySchema.getPropertyName()) + ":" + this.generateForTypeWithName(jsonPropertySchema.getPropertyType(), jsonPropertySchema.getPropertyName());
    }

    private String generateForTypeWithName(JsonPropertyType propertyType, String propertName) {
        if (propertyType == null) {
            return "\"\"";
        }
        switch (propertyType) {
            case Boolean: {
                return String.valueOf(this.random.nextBoolean());
            }
            case Integer: {
                return String.valueOf(new Digits().generateInteger());
            }
            case Number: {
                return String.valueOf(this.random.nextDouble());
            }
        }
        return "\"" + this.factory.forProperty(propertName).create() + "\"";
    }

    private String formatPropertyName(String propertyName) {
        return "\"" + propertyName + "\"";
    }
}

