/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.creational.servicefactory;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import nyla.solutions.core.exception.SetupException;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.operations.ClassPath;
import nyla.solutions.core.patterns.creational.servicefactory.ConfigServiceFactory;
import nyla.solutions.core.util.Config;

public abstract class ServiceFactory {
    public static final String SERVICE_FACTORY_PROP_NM = ServiceFactory.class.getName();
    public static final String DEFAULT_SERVICE_FACTORY = ConfigServiceFactory.class.getName();
    public static final String SERVICE_FACTORY_CONFIG_PROP = "ServiceFactory.config";
    public static final String DEFAULT_CONFIG_PROP_VALUE = "service.factory.xml";
    private static Map<String, ServiceFactory> instances = new Hashtable<String, ServiceFactory>();

    public static String getConfigProperty() {
        String property = Config.settings().getProperty(SERVICE_FACTORY_CONFIG_PROP, "");
        if (property.length() == 0) {
            property = System.getProperty(SERVICE_FACTORY_CONFIG_PROP, DEFAULT_CONFIG_PROP_VALUE);
        }
        return property;
    }

    public static synchronized ServiceFactory getInstance() {
        return ServiceFactory.getInstance(null, null);
    }

    public static synchronized ServiceFactory getInstance(String configurationPath) {
        return ServiceFactory.getInstance(null, configurationPath);
    }

    public static synchronized ServiceFactory getInstance(Class<?> aClass) {
        return ServiceFactory.getInstance(aClass, null);
    }

    public static synchronized ServiceFactory getInstance(Class<?> aClass, String configurationPath) {
        if (configurationPath == null) {
            configurationPath = "";
        }
        if (instances.get(configurationPath) == null) {
            instances.put(configurationPath, ServiceFactory.createServiceFactory(aClass, configurationPath));
        }
        return instances.get(configurationPath);
    }

    private static synchronized ServiceFactory createServiceFactory(Class<?> aClass, String configurationFile) {
        String factoryClassName = null;
        if (aClass != null) {
            factoryClassName = Config.settings().getProperty(ServiceFactory.class.getName() + "." + aClass.getName());
        }
        if (factoryClassName == null || factoryClassName.length() == 0) {
            factoryClassName = Config.settings().getProperty(SERVICE_FACTORY_PROP_NM, DEFAULT_SERVICE_FACTORY);
        }
        try {
            Class<?> factoryClass = Class.forName(factoryClassName);
            if (configurationFile == null || configurationFile.length() == 0) {
                return (ServiceFactory)ClassPath.newInstance(factoryClassName);
            }
            Object[] inputs = new Object[]{configurationFile};
            Class[] parameterTypes = new Class[]{String.class};
            return (ServiceFactory)factoryClass.getConstructor(parameterTypes).newInstance(inputs);
        }
        catch (SetupException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SetupException(e.getMessage(), e);
        }
    }

    public abstract <T> T create(Class<?> var1);

    public abstract <T> T create(Class<?> var1, String var2);

    public abstract <T> T create(String var1);

    public <T> void createForNames(String[] names, T[] objectOutput) {
        if (objectOutput == null || objectOutput.length == 0) {
            throw new IllegalArgumentException("Non empty objectOutput");
        }
        if (names == null || names.length == 0) {
            return;
        }
        String name = null;
        Object obj = null;
        try {
            for (int i = 0; i < names.length; ++i) {
                name = names[i];
                obj = this.create(name);
                objectOutput[i] = this.create(name);
            }
        }
        catch (ArrayStoreException e) {
            if (obj == null) {
                throw e;
            }
            throw new SystemException("Cannot assign bean \"" + name + "\" class:" + obj.getClass().getName() + " to array of objectOutput arrray class:" + Arrays.asList(objectOutput), e);
        }
    }

    public abstract <T> T create(String var1, Object[] var2);

    public abstract <T> T create(String var1, Object var2);
}

