/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.decorator;

import nyla.solutions.core.data.Textable;
import nyla.solutions.core.exception.RequiredException;
import nyla.solutions.core.patterns.decorator.TextDecorator;
import nyla.solutions.core.util.Text;

public class ReplaceRegExpTextDecorator
implements TextDecorator<Textable> {
    private String replacement;
    private String regExp;
    private Textable target;

    public ReplaceRegExpTextDecorator(Textable textable) {
        this.target = textable;
    }

    public ReplaceRegExpTextDecorator() {
    }

    @Override
    public String getText() {
        if (this.target == null) {
            throw new RequiredException("this.target in ReplaceTextDecorator");
        }
        return Text.replaceForRegExprWith(this.target.getText(), this.regExp, this.replacement);
    }

    @Override
    public Textable getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(Textable target) {
        this.target = target;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public String getRegExp() {
        return this.regExp;
    }

    public void setRegExp(String regExp) {
        this.regExp = regExp;
    }
}

