/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.expression;

import nyla.solutions.core.patterns.expression.BooleanExpression;

public class ComparableExpression<T extends Comparable>
implements BooleanExpression<T> {
    private static final int GREATER_THAN_COMPARE_TO = 1;
    private static final int LESS_THAN_COMPARE_TO = -1;
    private static final int EQUALS_TO_COMPARE_TO = 0;
    private final T value;
    private final int expectedCompareTo;

    public ComparableExpression(T value, int expectedCompareTo) {
        this.value = value;
        this.expectedCompareTo = expectedCompareTo;
    }

    public static <T extends Comparable> ComparableExpression<T> greaterThan(T value) {
        return new ComparableExpression<T>(value, 1);
    }

    public static <T extends Comparable> ComparableExpression<T> lessThan(T value) {
        return new ComparableExpression<T>(value, -1);
    }

    public static <T extends Comparable> ComparableExpression<T> equalsTo(T value) {
        return new ComparableExpression<T>(value, 0);
    }

    @Override
    public Boolean apply(T t) {
        return this.expectedCompareTo == t.compareTo(this.value);
    }
}

