/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.expression.bre;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import nyla.solutions.core.exception.RequiredException;

public class BusinessRuleEngine<T, R> {
    private final Map<String, Function<T, R>> rules;

    public BusinessRuleEngine(Map<String, Function<T, R>> rules) {
        if (rules == null || rules.isEmpty()) {
            throw new RequiredException("Map of rules");
        }
        this.rules = rules;
    }

    public static BreBuilder builder() {
        return new BreBuilder();
    }

    public R applyForRule(String ruleName, T value) {
        Function<T, R> rule = this.rules.get(ruleName);
        if (rule == null) {
            return null;
        }
        return rule.apply(value);
    }

    public static class BreBuilder<T, R> {
        private Map<String, Function<T, R>> rules = new HashMap<String, Function<T, R>>();

        private BreBuilder() {
        }

        public BreBuilder rule(String ruleName, Function<T, R> rule) {
            this.rules.put(ruleName, rule);
            return this;
        }

        public BusinessRuleEngine<T, R> build() {
            return new BusinessRuleEngine<T, R>(this.rules);
        }
    }
}

