/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nyla.solutions.core.util.Organizer;

public class BindVariableInterpreter {
    private final String sql;
    private final Map<String, List<Integer>> fieldPositionMap;
    private static final String BIND_VAR_EXP = "(\\:+([a-zA-Z0-9]*[\\_]*[a-zA-Z0-9]*)*)";

    public BindVariableInterpreter(String sql) {
        StringBuilder preparedSql = new StringBuilder();
        this.fieldPositionMap = new HashMap<String, List<Integer>>();
        Pattern pattern = Pattern.compile(BIND_VAR_EXP);
        Matcher matcher = pattern.matcher(sql);
        int i = 1;
        while (matcher.find()) {
            String variable = matcher.group();
            String formattedVariable = BindVariableInterpreter.formatStoredVariableName(variable);
            List<Integer> indexes = this.fieldPositionMap.get(formattedVariable);
            if (indexes == null) {
                this.fieldPositionMap.put(formattedVariable, Organizer.toList(i++));
                continue;
            }
            indexes.add(i++);
            this.fieldPositionMap.put(formattedVariable, indexes);
        }
        this.sql = matcher.replaceAll("?");
    }

    protected static String formatStoredVariableName(String varName) {
        return varName.trim().replace(":", "").toUpperCase().replace(",", "");
    }

    public Integer indexOf(String variable) {
        if (variable == null) {
            throw new NullPointerException("Variable name not provided");
        }
        Integer position = this.indexOfNullable(variable);
        if (position == null) {
            throw new NullPointerException("Variable: " + variable + " not found in variables:" + this.fieldPositionMap.keySet());
        }
        return position;
    }

    public Integer indexOfNullable(String variable) {
        List<Integer> results = this.indexesOf(variable);
        if (results == null || results.isEmpty()) {
            return null;
        }
        return results.iterator().next();
    }

    public List<Integer> indexesOf(String variable) {
        if (variable == null) {
            return null;
        }
        return this.fieldPositionMap.get(variable.toUpperCase());
    }

    public String toPreparedStmtSql() {
        return this.sql;
    }

    public PreparedStatement constructPreparedStatementWithMap(Connection connection, Map<?, ?> map) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(this.toPreparedStmtSql());
        Object index = null;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.setObject(preparedStatement, String.valueOf(entry.getKey()), entry.getValue());
        }
        return preparedStatement;
    }

    public void setObject(PreparedStatement preparedStatement, String name, Object value) throws SQLException {
        if (preparedStatement == null) {
            return;
        }
        Integer index2 = null;
        List<Integer> indexes = this.indexesOf(name);
        if (indexes == null || indexes.isEmpty()) {
            return;
        }
        try {
            for (Integer index2 : indexes) {
                preparedStatement.setObject(index2, value);
            }
        }
        catch (SQLException e) {
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SQLException("Cannot set index:" + index2 + " in indexes:" + indexes + "  with value:" + value + " ERROR:" + e.getMessage(), e);
        }
    }
}

