/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.jdbc.batch;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Supplier;
import nyla.solutions.core.exception.DataException;

public class ResultSetSupplier
implements Supplier<ResultSet>,
AutoCloseable {
    private final ResultSet resultSet;

    public ResultSetSupplier(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    @Override
    public ResultSet get() {
        try {
            if (this.resultSet.next()) {
                return this.resultSet;
            }
            return null;
        }
        catch (SQLException e) {
            throw new DataException("ERROR: " + e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        try {
            this.resultSet.close();
        }
        catch (SQLException e) {
            throw new DataException(e.getMessage(), e);
        }
    }
}

