/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.jdbc.dataSource;

import java.sql.Connection;
import nyla.solutions.core.patterns.creational.Creator;
import nyla.solutions.core.patterns.jdbc.Sql;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.settings.Settings;

public class ConnectionCreator
implements Creator<Connection> {
    private final String driver;
    private final String user;
    private final char[] password;
    private final String url;

    ConnectionCreator(String driver, String url, String user, char[] password) {
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Connection create() {
        return Sql.createConnection(this.driver, this.url, this.user, this.password);
    }

    public static class Builder {
        private static final String JDBC_USER = "SQL_JDBC_USER";
        private static final String JDBC_PASSWORD = "SQL_JDBC_PASSWORD";
        private static final String JDBC_URL = "SQL_JDBC_URL";
        private static final String JDBC_DRIVER = "SQL_JDBC_DRIVER";
        private String driver;
        private String url;
        private String user;
        private char[] password;

        public ConnectionCreator build() {
            return new ConnectionCreator(this.driver, this.url, this.user, this.password);
        }

        public Builder driver(String driver) {
            this.driver = driver;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder password(char[] password) {
            this.password = password;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder constructFromSettings() {
            return this.constructFromSettings(Config.settings());
        }

        public Builder constructFromSettings(Settings settings) {
            return this.user(settings.getProperty(JDBC_USER, "")).password(settings.getPropertyPassword(JDBC_PASSWORD, "")).url(settings.getProperty(JDBC_URL)).driver(settings.getProperty(JDBC_DRIVER));
        }
    }
}

