/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.loadbalancer;

import java.io.IOException;
import java.net.ServerSocket;
import nyla.solutions.core.patterns.loadbalancer.NetworkGateway;
import nyla.solutions.core.patterns.loadbalancer.RoundRobin;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.Debugger;

public class NetworkLoadBalancer
implements Runnable {
    private final int port;
    private final RoundRobin<NetworkGateway> roundRobin;

    public NetworkLoadBalancer(int port, RoundRobin<NetworkGateway> roundRobin) {
        this.port = port;
        this.roundRobin = roundRobin;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        Debugger.println(this, "Starting to listen on port: " + this.port);
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                socket = new ServerSocket(this.port);
                try {
                    this.roundRobin.next().join(socket.accept());
                }
                finally {
                    socket.close();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            Debugger.printError(e);
            throw new RuntimeException(e);
        }
        ** GOTO lbl-1000
    }

    public static void main(String[] args) throws IOException {
        Config.loadArgs(args);
        RoundRobin<NetworkGateway> rr = new RoundRobin<NetworkGateway>(NetworkGateway.builder().commaSeparatedHostPort(Config.settings().getProperty("NETWORK_GATEWAYS"), Config.settings().getPropertyInteger("SOCKET_BUFFER_SIZE", 32000)).buildArray());
        int serverPort = Config.settings().getPropertyInteger("SERVER_PORT");
        NetworkLoadBalancer lb = new NetworkLoadBalancer(serverPort, rr);
        lb.run();
    }
}

