/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.pooling;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import nyla.solutions.core.patterns.creational.Creator;

public class Pool<T> {
    private final int size;
    private final Queue<T> queue;
    private final Creator<T> creator;

    public Pool(int size, Creator<T> creator) {
        this.size = size;
        this.queue = new ConcurrentLinkedQueue<T>();
        this.creator = creator;
        this.constructPool();
    }

    private synchronized void constructPool() {
        while (this.queue.size() < this.size) {
            this.queue.add(this.creator.create());
        }
    }

    public synchronized T acquire() {
        T item = null;
        if (!this.queue.isEmpty()) {
            item = this.queue.poll();
        }
        return item;
    }

    public synchronized void release(T item) {
        this.queue.add(item);
    }
}

