/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.reflection;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import nyla.solutions.core.patterns.reflection.ClassType;
import nyla.solutions.core.patterns.reflection.EnumTypeSchema;
import nyla.solutions.core.patterns.reflection.Mirror;
import nyla.solutions.core.patterns.reflection.PrimitiveTypeSchema;
import nyla.solutions.core.patterns.reflection.TypeSchema;

public class ComplexTypeSchema
implements Serializable,
TypeSchema {
    private Class<?> fieldClass;
    private final ClassType classType;
    private HashSet<TypeSchema> primitiveFieldSchemas = new HashSet();
    private HashSet<TypeSchema> complexFieldSchemas = new HashSet();
    private String fieldName;
    private String className;
    private static final long serialVersionUID = 8221193500710478919L;

    public ComplexTypeSchema(Field field) {
        this(field.getName(), field.getType());
    }

    public ComplexTypeSchema(Class<?> fieldClass) {
        this(null, fieldClass);
    }

    public ComplexTypeSchema(String fieldName, Class<?> fieldClass) {
        Type[] generics;
        this.setFieldName(fieldName);
        this.fieldClass = fieldClass;
        this.className = fieldClass.getName();
        this.classType = fieldClass.isArray() ? ClassType.array : (java.sql.Date.class.equals(fieldClass) || Date.class.equals(fieldClass) ? ClassType.date : (Calendar.class.isAssignableFrom(fieldClass) ? ClassType.calendar : (Timestamp.class.equals(fieldClass) ? ClassType.timestamp : (Time.class.equals(fieldClass) ? ClassType.time : ((generics = fieldClass.getGenericInterfaces()) != null && generics.length > 0 ? ClassType.generic : ClassType.object)))));
        Field[] fields = fieldClass.getFields();
        Class<?> declaringClass = null;
        for (int i = 0; i < fields.length; ++i) {
            declaringClass = fields[i].getType();
            if (Mirror.isPrimitive(declaringClass)) {
                this.primitiveFieldSchemas.add(new PrimitiveTypeSchema(fields[i]));
                continue;
            }
            if (declaringClass.isEnum()) {
                this.primitiveFieldSchemas.add(new EnumTypeSchema(fields[i]));
                continue;
            }
            this.complexFieldSchemas.add(new ComplexTypeSchema(fields[i]));
        }
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public ClassType getClassType() {
        return this.classType;
    }

    @Override
    public Class<?> getFieldClass() {
        return this.fieldClass;
    }

    public void setFieldClass(Class<?> fieldClass) {
        this.fieldClass = fieldClass;
    }

    @Override
    public TypeSchema[] getFieldsTypes() {
        TypeSchema[] typeSchemas = new TypeSchema[this.primitiveFieldSchemas.size() + this.complexFieldSchemas.size()];
        int i = 0;
        for (TypeSchema ts : this.primitiveFieldSchemas) {
            typeSchemas[i++] = ts;
        }
        for (TypeSchema ts : this.complexFieldSchemas) {
            typeSchemas[i++] = ts;
        }
        return typeSchemas;
    }

    public String toString() {
        return "ComplexTypeSchema [fieldClass=" + this.fieldClass + ", classType=" + this.classType + ", primitiveFieldSchemas=" + this.primitiveFieldSchemas + ", complexFieldSchemas=" + this.complexFieldSchemas + ", fieldName=" + this.fieldName + ", className=" + this.className + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.classType == null ? 0 : this.classType.hashCode());
        result = 31 * result + (this.complexFieldSchemas == null ? 0 : this.complexFieldSchemas.hashCode());
        result = 31 * result + (this.fieldClass == null ? 0 : this.fieldClass.hashCode());
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        result = 31 * result + (this.primitiveFieldSchemas == null ? 0 : this.primitiveFieldSchemas.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComplexTypeSchema other = (ComplexTypeSchema)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.classType != other.classType) {
            return false;
        }
        if (this.complexFieldSchemas == null ? other.complexFieldSchemas != null : !this.complexFieldSchemas.equals(other.complexFieldSchemas)) {
            return false;
        }
        if (this.fieldClass == null ? other.fieldClass != null : !this.fieldClass.equals(other.fieldClass)) {
            return false;
        }
        if (this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName)) {
            return false;
        }
        return !(this.primitiveFieldSchemas == null ? other.primitiveFieldSchemas != null : !this.primitiveFieldSchemas.equals(other.primitiveFieldSchemas));
    }
}

