/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.reflection;

import java.io.Serializable;
import java.lang.reflect.Field;
import nyla.solutions.core.patterns.reflection.ClassType;
import nyla.solutions.core.patterns.reflection.TypeSchema;

public class PrimitiveTypeSchema
implements Serializable,
TypeSchema {
    private static final long serialVersionUID = 8221193500710478919L;
    private Class<?> fieldClass;
    private String fieldName = null;
    private String className = null;

    public PrimitiveTypeSchema(Field field) {
        this(field.getName(), field.getType());
    }

    public PrimitiveTypeSchema(Class<?> aClass) {
        this.className = aClass.getName();
        this.fieldClass = aClass;
    }

    public PrimitiveTypeSchema(String fieldName, Class<?> aClass) {
        this.setFieldName(fieldName);
        this.fieldClass = aClass;
        this.className = aClass.getName();
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String toString() {
        return "PrimitiveTypeSchema [ fieldName=" + this.fieldName + ", className=" + this.className + "]";
    }

    @Override
    public ClassType getClassType() {
        return ClassType.primitive;
    }

    @Override
    public Class<?> getFieldClass() {
        return this.fieldClass;
    }

    public void setFieldClass(Class<?> fieldClass) {
        this.fieldClass = fieldClass;
    }

    @Override
    public TypeSchema[] getFieldsTypes() {
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.fieldClass == null ? 0 : this.fieldClass.hashCode());
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrimitiveTypeSchema other = (PrimitiveTypeSchema)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.fieldClass == null ? other.fieldClass != null : !this.fieldClass.equals(other.fieldClass)) {
            return false;
        }
        return !(this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName));
    }
}

