/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.search.queryService;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import nyla.solutions.core.data.DataRow;
import nyla.solutions.core.data.DataRowCreator;
import nyla.solutions.core.patterns.iteration.PageCriteria;
import nyla.solutions.core.patterns.iteration.Pagination;
import nyla.solutions.core.patterns.iteration.PagingCollection;
import nyla.solutions.core.patterns.search.queryService.QuestCriteria;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.JavaBean;

public class QuestDirector {
    private final Pagination pagination;
    public static final int BATCH_SIZE = Config.settings().getPropertyInteger((Class<?>)QuestDirector.class, "BATCH_SIZE", 10);

    public QuestDirector(Pagination pagination) {
        this.pagination = pagination;
    }

    public final <T> Collection<DataRow> constructDataRows(Iterator<T> iterator, QuestCriteria questCriteria, DataRowCreator visitor) {
        if (iterator == null) {
            return null;
        }
        ArrayList<DataRow> dataRows = new ArrayList<DataRow>(BATCH_SIZE);
        boolean usePaging = false;
        boolean savePagination = false;
        int pageSize = 0;
        PageCriteria pageCriteria = questCriteria.getPageCriteria();
        Pagination pagination = null;
        if (pageCriteria != null && (pageSize = pageCriteria.getSize()) > 0) {
            usePaging = true;
            savePagination = pageCriteria.isSavePagination();
            if (savePagination) {
                pagination = pagination.getPaginationById(pageCriteria.getId());
            }
        }
        if (usePaging) {
            while (iterator.hasNext()) {
                item = iterator.next();
                JavaBean.acceptVisitor(item, visitor);
                DataRow dataRow = visitor.getDataRow();
                dataRows.add(dataRow);
                if (savePagination) {
                    pagination.store(dataRow, pageCriteria);
                }
                visitor.clear();
                if (dataRows.size() < pageSize) continue;
                if (!savePagination || !iterator.hasNext()) break;
                pagination.constructPaging(iterator, pageCriteria, visitor);
                break;
            }
        } else {
            while (iterator.hasNext()) {
                item = iterator.next();
                JavaBean.acceptVisitor(item, visitor);
                dataRows.add(visitor.getDataRow());
                visitor.clear();
            }
        }
        dataRows.trimToSize();
        PagingCollection<DataRow> pagingCollection = new PagingCollection<DataRow>(dataRows, questCriteria.getPageCriteria());
        return pagingCollection;
    }
}

