/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.search.queryService;

import java.util.Comparator;
import nyla.solutions.core.data.DataRow;
import nyla.solutions.core.exception.ConfigException;
import nyla.solutions.core.patterns.creational.servicefactory.ServiceFactory;
import nyla.solutions.core.patterns.expression.BooleanExpression;
import nyla.solutions.core.patterns.iteration.PageCriteria;
import nyla.solutions.core.patterns.iteration.Pagination;
import nyla.solutions.core.patterns.search.queryService.QuestCriteria;
import nyla.solutions.core.patterns.search.queryService.QuestFinder;
import nyla.solutions.core.patterns.search.queryService.QuestMgr;
import nyla.solutions.core.patterns.search.queryService.QuestService;
import nyla.solutions.core.patterns.workthread.ExecutorBoss;
import nyla.solutions.core.util.Config;

public class QuestFactory {
    private static ExecutorBoss executorBoss = null;
    private static int threadCount = Config.settings().getPropertyInteger("QUESTFACTORY_THREAD_CNT", 10);
    private final ServiceFactory serviceFactory;
    private final Pagination pagination;

    public QuestFactory(ServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
        this.pagination = (Pagination)this.serviceFactory.create(Pagination.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorBoss createExecutorBoss() {
        Class<QuestFactory> clazz = QuestFactory.class;
        synchronized (QuestFactory.class) {
            if (executorBoss == null) {
                executorBoss = new ExecutorBoss(threadCount);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return executorBoss;
        }
    }

    public static QuestFactory getInstance() {
        return new QuestFactory(ServiceFactory.getInstance());
    }

    public QuestFinder createFinder(QuestCriteria criteria, String dataSource) {
        try {
            QuestFinder finder = (QuestFinder)this.serviceFactory.create(dataSource);
            finder.assignCriteria(criteria, dataSource);
            return finder;
        }
        catch (ConfigException e) {
            throw new ConfigException("Connect create new instance " + QuestFinder.class.getName() + " " + e.getMessage(), e);
        }
    }

    public QuestService createQuestService() {
        return new QuestMgr(this);
    }

    public Comparator<DataRow> createComparator(String sorter) {
        return (Comparator)this.serviceFactory.create(sorter);
    }

    public BooleanExpression<DataRow> createBooleanExpression(String filter) {
        return (BooleanExpression)this.serviceFactory.create(filter);
    }

    public Pagination getPagination(PageCriteria pageCriteria) {
        return this.pagination.getPaginationById(pageCriteria.getId());
    }
}

