/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.workthread;

import java.util.ConcurrentModificationException;
import java.util.concurrent.ArrayBlockingQueue;
import nyla.solutions.core.patterns.workthread.WorkQueue;

public class MemorizedQueue
implements WorkQueue {
    private final ArrayBlockingQueue<Runnable> queue;

    public MemorizedQueue(int capacity) {
        this.queue = new ArrayBlockingQueue(capacity);
    }

    public MemorizedQueue(Runnable ... runners) {
        this(runners.length);
        this.add(runners);
    }

    public synchronized void add(Runnable ... tasks) {
        for (Runnable runner : tasks) {
            try {
                this.queue.put(runner);
            }
            catch (InterruptedException e) {
                throw new ConcurrentModificationException(e);
            }
        }
    }

    @Override
    public synchronized Runnable nextTask() {
        return this.queue.poll();
    }

    @Override
    public boolean hasMoreTasks() {
        return !this.queue.isEmpty();
    }

    @Override
    public int size() {
        return this.queue.size();
    }
}

