/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.security.data;

import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nyla.solutions.core.exception.SecurityException;
import nyla.solutions.core.security.data.AccessControl;
import nyla.solutions.core.security.data.Acl;
import nyla.solutions.core.security.data.AclEditor;
import nyla.solutions.core.security.data.Permission;
import nyla.solutions.core.security.data.SecurityAccessControl;
import nyla.solutions.core.security.data.SecurityGroup;
import nyla.solutions.core.security.data.SecurityPermission;
import nyla.solutions.core.security.data.SecurityUser;

public class SecurityAcl
implements Acl,
AclEditor {
    private static final long serialVersionUID = 15616038981342591L;
    private Map<Principal, Set<AccessControl>> entries = new HashMap<Principal, Set<AccessControl>>();
    private final String name;

    public SecurityAcl() {
        this("SecurityAcl");
    }

    public SecurityAcl(String aName) {
        this.name = aName;
    }

    @Override
    public synchronized String getName() {
        return this.name;
    }

    @Override
    public synchronized boolean addEntry(Principal caller, Principal principal, Permission permission) {
        return this.addEntry(caller, new SecurityAccessControl(principal, permission));
    }

    @Override
    public synchronized boolean addEntry(Principal caller, Principal principal, String permission) {
        return this.addEntry(caller, new SecurityAccessControl(principal, permission));
    }

    @Override
    public synchronized boolean addEntry(Principal caller, Principal principal, boolean negative, String permission) {
        return this.addEntry(caller, new SecurityAccessControl(principal, negative, permission));
    }

    @Override
    public synchronized boolean addEntry(Principal caller, AccessControl aclEntry) {
        if (aclEntry == null) {
            return false;
        }
        Principal principal = aclEntry.getPrincipal();
        Set<AccessControl> currentAcl = this.entries.get(principal);
        if (currentAcl != null) {
            for (AccessControl currentEntry : currentAcl) {
                if (!principal.equals(currentEntry.getPrincipal())) continue;
                this.mergePermissions(aclEntry, currentEntry);
            }
        } else {
            HashSet<AccessControl> set = new HashSet<AccessControl>();
            set.add(aclEntry);
            this.entries.put(principal, set);
        }
        return true;
    }

    @Override
    public void mergePermissions(AccessControl from, AccessControl to) {
        boolean changeNegative;
        if (from == null || to == null) {
            return;
        }
        List<Permission> otherPermissions = from.getPermissions();
        if (otherPermissions == null) {
            return;
        }
        boolean bl = changeNegative = from.isNegative() != to.isNegative();
        if (changeNegative) {
            throw new SecurityException("Cannot change or mixed different negative property for ACL from:" + from + " to ACL:" + to + "  permission must be either all negative or all positive for a principal");
        }
        Iterator<Permission> i = otherPermissions.iterator();
        while (i.hasNext()) {
            to.addPermission(i.next());
        }
    }

    @Override
    public synchronized boolean revokeAccess(Principal caller, AccessControl aclEntry) {
        if (aclEntry == null) {
            return false;
        }
        Principal principal = aclEntry.getPrincipal();
        if (principal == null) {
            return false;
        }
        Set<AccessControl> set = this.entries.get(aclEntry.getPrincipal());
        if (set == null || set.isEmpty()) {
            return false;
        }
        boolean r = set.remove(aclEntry);
        this.entries.put(principal, set);
        return r;
    }

    @Override
    public synchronized boolean checkPermission(Principal principal, Permission permission) {
        if (principal == null) {
            return false;
        }
        if (permission == null) {
            return false;
        }
        Set<AccessControl> set = this.entries.get(principal);
        if (set != null && !set.isEmpty()) {
            for (AccessControl accessControl : set) {
                if (!accessControl.checkPermission(permission)) continue;
                return true;
            }
        }
        if (SecurityUser.class.isAssignableFrom(principal.getClass())) {
            return this.checkPermission(((SecurityUser)principal).getGroups(), permission);
        }
        return false;
    }

    @Override
    public boolean checkPermission(Set<SecurityGroup> groups, Permission permission) {
        if (groups == null || groups.isEmpty()) {
            return false;
        }
        for (SecurityGroup group : groups) {
            if (!this.checkPermission((Principal)group, permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean checkPermission(Principal aPrincipal, String aPermission) {
        if (aPermission == null) {
            return false;
        }
        SecurityPermission securityPermission = new SecurityPermission(aPermission);
        return this.checkPermission(aPrincipal, (Permission)securityPermission);
    }

    @Override
    public boolean isEmpty() {
        return this.entries == null || this.entries.isEmpty();
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SecurityAcl [entries=").append(this.entries).append(", name=").append(this.name).append("]");
        return builder.toString();
    }
}

