/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.util;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import nyla.solutions.core.data.clock.Day;
import nyla.solutions.core.exception.ConfigException;
import nyla.solutions.core.exception.ConfigLockException;
import nyla.solutions.core.patterns.observer.SubjectObserver;
import nyla.solutions.core.util.Text;
import nyla.solutions.core.util.settings.ConfigSettings;
import nyla.solutions.core.util.settings.Settings;

public class Config {
    private static final ReentrantLock lock = new ReentrantLock();
    public static final String RESOURCE_BUNDLE_NAME = "config";
    public static final String SYS_PROPERTY = "config.properties";
    public static final String DEFAULT_PROP_FILE_NAME = "config.properties";
    private Settings settings;
    private static final long lockPeriodMs = 3000L;
    private static Config instance = null;

    public Config() {
        this(new ConfigSettings());
    }

    public Config(Settings settings) {
        this.settings = settings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Config config() {
        if (!lock.tryLock(3000L, TimeUnit.MILLISECONDS)) throw new ConfigLockException("Get settings");
        try {
            if (instance == null) {
                instance = new Config();
            }
            Config config = instance;
            lock.unlock();
            return config;
        }
        catch (Throwable throwable) {
            try {
                lock.unlock();
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new ConfigException(e);
            }
        }
    }

    public static String interpret(String property) {
        return Config.config().getSettings().interpret(property);
    }

    public static void setAlwaysReload(boolean alwaysReload) {
        Config.config().getSettings().setAlwaysReload(alwaysReload);
    }

    public static void reLoad() {
        Config.config().getSettings().reLoad();
    }

    public static String getLocation() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public String getPropertyEnv(String key) {
        String env = Config.sanitizeEnvVarNAme(key);
        return this.getSettings().getProperty(env);
    }

    public String getPropertyEnv(String key, String aDefault) {
        String env = Config.sanitizeEnvVarNAme(key);
        return this.getSettings().getProperty(env, aDefault);
    }

    public static String sanitizeEnvVarNAme(String key) {
        String env = Text.replaceForRegExprWith(key, "[-\\. ]", "_").toUpperCase();
        return env;
    }

    public Day getDay(String key) {
        return new Day(this.getSettings().getProperty(key));
    }

    public static Settings settings() {
        return Config.config().getSettings();
    }

    public static void setProperties(Properties properties) {
        block6: {
            try {
                if (lock.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    try {
                        Config.config().getSettings().setProperties(properties);
                        break block6;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                throw new ConfigLockException("Setting properties");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getUserDir() {
        return System.getProperty("user.dir");
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings theSettings) {
        try {
            if (lock.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                if (theSettings == null) {
                    throw new IllegalArgumentException("theSettings is required");
                }
            } else {
                throw new ConfigLockException("Setting settings");
            }
            this.settings = theSettings;
        }
        catch (InterruptedException e) {
            throw new ConfigException(e);
        }
    }

    public String getPropertyEnv(String key, Map<?, ?> properties) {
        String value = null;
        if (properties != null && (value = (String)properties.get(key)) != null) {
            return value.toString();
        }
        value = this.getPropertyEnv(key, "");
        String text = value.toString();
        if (text.length() == 0) {
            return null;
        }
        return text;
    }

    public static void registerObserver(SubjectObserver<Settings> settingsObserver) {
        Config.settings().registerObserver(settingsObserver);
    }

    public Day getPropertyDay(String key) {
        return new Day(this.getSettings().getProperty(key));
    }

    public static Settings loadArgs(String[] args) {
        return Config.settings().loadArgs(args);
    }

    public String getPropertyEnv(String key, Properties properties, String defaultValue) {
        String value = this.getPropertyEnv(key, properties);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return value;
    }
}

