/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import nyla.solutions.core.data.AbstractAuditable;
import nyla.solutions.core.data.Auditable;
import nyla.solutions.core.data.Copier;
import nyla.solutions.core.data.Criteria;
import nyla.solutions.core.data.Mappable;
import nyla.solutions.core.data.NumberedProperty;
import nyla.solutions.core.data.PrimaryKey;
import nyla.solutions.core.data.Property;
import nyla.solutions.core.exception.RequiredException;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.operations.logging.Log;
import nyla.solutions.core.patterns.expression.BooleanExpression;
import nyla.solutions.core.patterns.iteration.PageCriteria;
import nyla.solutions.core.patterns.iteration.Paging;
import nyla.solutions.core.patterns.iteration.PagingCollection;
import nyla.solutions.core.util.BeanComparator;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.Debugger;
import nyla.solutions.core.util.JavaBean;
import nyla.solutions.core.util.Text;

public final class Organizer {
    private static final Log logger = Debugger.getLog(Organizer.class);

    private Organizer() {
    }

    public static <T> T first(T[] array) {
        if (array == null || array.length < 1) {
            return null;
        }
        return array[0];
    }

    public static <T> void flatten(Collection<?> input, Collection<T> flattenOutput) {
        if (input == null || input.isEmpty() || flattenOutput == null) {
            return;
        }
        for (Object inputObj : input) {
            if (inputObj == null) continue;
            if (inputObj instanceof Collection) {
                Organizer.flatten((Collection)inputObj, flattenOutput);
                continue;
            }
            flattenOutput.add(inputObj);
        }
    }

    public static <T> Paging<T> flattenPaging(Collection<Paging<T>> collectionOfPaging) {
        if (collectionOfPaging == null || collectionOfPaging.isEmpty()) {
            return null;
        }
        PageCriteria pageCriteria = null;
        Paging<T> firstPaging = collectionOfPaging.iterator().next();
        if (firstPaging != null) {
            pageCriteria = firstPaging.getPageCriteria();
        }
        return Organizer.flattenPaging(collectionOfPaging, pageCriteria, null, null);
    }

    public static <T> Paging<T> flattenPaging(Collection<Paging<T>> collectionOfPaging, Comparator<T> sorter, BooleanExpression<T> filter) {
        if (collectionOfPaging == null || collectionOfPaging.isEmpty()) {
            return null;
        }
        PageCriteria pageCriteria = collectionOfPaging.iterator().next().getPageCriteria();
        return Organizer.flattenPaging(collectionOfPaging, pageCriteria, sorter, filter);
    }

    public static <T> Paging<T> flattenPaging(Collection<?> collectionOfPaging, PageCriteria pageCriteria, Comparator<T> sorter, BooleanExpression<T> filter) {
        if (collectionOfPaging == null || collectionOfPaging.isEmpty()) {
            return null;
        }
        Paging<Object> pagingResults = null;
        if (sorter != null) {
            TreeSet<T> treeSet = new TreeSet<T>(sorter);
            pagingResults = new PagingCollection<T>(treeSet, pageCriteria);
        }
        for (Object item : collectionOfPaging) {
            if (item instanceof Paging) {
                Paging paging = (Paging)item;
                if (pagingResults != null) {
                    Organizer.addAll(pagingResults, paging, filter);
                    continue;
                }
                pagingResults = paging;
                continue;
            }
            if (item == null) continue;
            if (pagingResults == null) {
                if (sorter != null) {
                    TreeSet<T> treeSet = new TreeSet<T>(sorter);
                    pagingResults = new PagingCollection<T>(treeSet, pageCriteria);
                } else {
                    pagingResults = new PagingCollection(new ArrayList(), pageCriteria);
                }
            }
            pagingResults.add(item);
        }
        return pagingResults;
    }

    public static <T> void addAll(Collection<T> pagingResults, Collection<T> paging, BooleanExpression<T> filter) {
        if (pagingResults == null || paging == null) {
            return;
        }
        if (filter != null) {
            for (T obj : paging) {
                if (!((Boolean)filter.apply((Object)obj)).booleanValue()) continue;
                pagingResults.add(obj);
            }
        } else {
            pagingResults.addAll(paging);
        }
    }

    public static <T> List<T> toList(T ... args) {
        if (args == null || args.length == 0) {
            return null;
        }
        ArrayList list = new ArrayList(args.length);
        Collections.addAll(list, args);
        return list;
    }

    public static <T> Set<T> toSet(T ... args) {
        if (args == null || args.length == 0) {
            return null;
        }
        HashSet set = new HashSet(args.length);
        Organizer.fill(set, args);
        return set;
    }

    public static <T> void fill(Collection<T> collection, T ... args) {
        if (collection == null || args == null) {
            return;
        }
        Collections.addAll(collection, args);
    }

    public static <T> List<Collection<T>> toPages(Collection<T> collection, int pageSize) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        int collectionSize = collection.size();
        if (pageSize <= 0 || collectionSize <= pageSize) {
            return Collections.singletonList(collection);
        }
        int initialSize = collectionSize / pageSize;
        ArrayList<Collection<T>> list = new ArrayList<Collection<T>>(initialSize);
        ArrayList<T> current = new ArrayList<T>();
        for (T object : collection) {
            current.add(object);
            if (current.size() < pageSize) continue;
            current.trimToSize();
            list.add(current);
            current = new ArrayList();
        }
        if (!current.isEmpty()) {
            list.add(current);
        }
        return list;
    }

    public static <K, V> List<Collection<K>> toKeyPages(Collection<Map.Entry<K, V>> mapEntries, int pageSize) {
        if (mapEntries == null || mapEntries.isEmpty()) {
            return null;
        }
        int collectionSize = mapEntries.size();
        if (pageSize <= 0 || collectionSize <= pageSize) {
            ArrayList<K> list = new ArrayList<K>(mapEntries.size());
            for (Map.Entry<K, V> entry : mapEntries) {
                if (entry == null) continue;
                list.add(entry.getKey());
            }
            if (list.isEmpty()) {
                return null;
            }
            return Collections.singletonList(list);
        }
        int initialSize = collectionSize / pageSize;
        ArrayList<Collection<K>> list = new ArrayList<Collection<K>>(initialSize);
        ArrayList<K> current = new ArrayList<K>();
        for (Map.Entry<K, V> entry : mapEntries) {
            current.add(entry.getKey());
            if (current.size() < pageSize) continue;
            current.trimToSize();
            list.add(current);
            current = new ArrayList();
        }
        if (!current.isEmpty()) {
            list.add(current);
        }
        return list;
    }

    public static <T> T findValueByKeyWithDefault(Map<?, ?> map, Object key, T defaultValue) {
        if (key == null || map == null) {
            return defaultValue;
        }
        Object value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    public static boolean isStringIn(String text, String ... list) {
        if (text == null) {
            return false;
        }
        for (String s : list) {
            if (!text.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static <T> T findByTextIgnoreCase(Collection<T> collection, String text) {
        if (text == null) {
            return null;
        }
        if (collection == null) {
            throw new RequiredException("aCollection in Organizer.findIgnoreCase");
        }
        for (T element : collection) {
            if (!text.equalsIgnoreCase(element.toString())) continue;
            return element;
        }
        return null;
    }

    public static <T> void addAll(Collection<T> list, T[] objects) {
        list.addAll(Arrays.asList(objects));
    }

    static <K, V> boolean doesListContainData(Object[] objects, Map<K, V> dataMap) {
        if (objects == null || objects.length == 0) {
            return false;
        }
        for (Object object : objects) {
            Map<Object, Object> objectMap = JavaBean.toMap(object);
            if (!Organizer.doesMapContainData(objectMap, dataMap)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesMapContainData(Map<Object, Object> aMap, Map<Object, Object> aData) {
        for (Map.Entry<Object, Object> entry : aData.entrySet()) {
            Object testMapKey = entry.getKey();
            if (String.valueOf(aMap.get(testMapKey)).equals(String.valueOf(entry.getValue()))) continue;
            return false;
        }
        return true;
    }

    public static <T> T[] copy(Object[] objects) {
        if (objects == null) {
            return null;
        }
        Object[] results = new Object[objects.length];
        System.arraycopy(objects, 0, results, 0, results.length);
        return results;
    }

    public static void copyToArray(Collection<Object> collection, Object[] objects) {
        System.arraycopy(collection.toArray(), 0, objects, 0, objects.length);
    }

    public static <K, V> void addMappableCopiesToMap(Collection<Mappable<K, V>> maps, Map<K, V> aMap) {
        if (maps == null || aMap == null) {
            return;
        }
        for (Mappable<K, V> aMappable : maps) {
            Mappable<K, V> mappable = aMappable;
            Copier previous = (Copier)aMap.get(mappable.getKey());
            if (previous != null) {
                previous.copy((Copier)((Object)mappable));
                continue;
            }
            aMap.put(mappable.getKey(), mappable.getValue());
        }
    }

    public static <T, K> Collection<T> findMapValuesByKey(Collection<K> keys, Map<K, T> map) {
        if (keys == null || map == null) {
            return null;
        }
        ArrayList<T> results = new ArrayList<T>(map.size());
        for (K key : keys) {
            T value = map.get(key);
            if (value == null) continue;
            results.add(value);
        }
        results.trimToSize();
        return results;
    }

    public static <T> void addAll(Collection<T> aFrom, Collection<T> aTo) {
        if (aFrom == null || aTo == null) {
            return;
        }
        for (T t : aFrom) {
            T object = t;
            if (object == null) continue;
            aTo.add(object);
        }
    }

    public static boolean isEmpty(Collection<?> aCollection) {
        return aCollection == null || aCollection.isEmpty();
    }

    public static boolean isEmpty(Object[] objects) {
        return objects == null || objects.length == 0;
    }

    public static boolean isIntegerIn(Integer aInt, Integer[] aIntegers) {
        if (aIntegers == null || aInt == null) {
            return false;
        }
        for (Integer aInteger : aIntegers) {
            if (!aInt.equals(aInteger)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Criteria> constructCriteriaMap(Collection<Criteria> collection) {
        if (collection == null) {
            return null;
        }
        HashMap<String, Criteria> map = new HashMap<String, Criteria>(collection.size());
        Iterator<Criteria> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Criteria value;
            Criteria criteria = value = iterator.next();
            map.put(criteria.getId(), criteria);
        }
        return map;
    }

    public static Map<Integer, PrimaryKey> constructPrimaryKeyMap(Collection<PrimaryKey> aPrimaryKeys) {
        if (aPrimaryKeys == null) {
            return null;
        }
        HashMap<Integer, PrimaryKey> map = new HashMap<Integer, PrimaryKey>(aPrimaryKeys.size());
        for (PrimaryKey primaryKey : aPrimaryKeys) {
            map.put(primaryKey.getPrimaryKey(), primaryKey);
        }
        return map;
    }

    public static Property findPropertyByName(String aName, Collection<Property> properties) {
        if (aName == null) {
            throw new IllegalArgumentException("aName required in Organizer.findPropertyByName");
        }
        if (properties == null) {
            throw new IllegalArgumentException("aProperties required in Organizer.findPropertyByName");
        }
        for (Property value : properties) {
            Property property = value;
            if (!aName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    public static <K> void makeCopies(Map<K, Copier> aFrom, Map<K, Copier> aTo) {
        Organizer.makeAuditableCopies(aFrom, aTo, null);
    }

    public static void makeCopies(Collection<Copier> aFrom, Collection<Copier> aTo) {
        if (aFrom == null || aTo == null) {
            return;
        }
        ArrayList<Copier> fromList = new ArrayList<Copier>(aFrom);
        ArrayList<Copier> toList = new ArrayList<Copier>(aTo);
        Collections.sort(fromList);
        Collections.sort(toList);
        Iterator iterator = toList.iterator();
        Iterator i = fromList.iterator();
        while (i.hasNext() && iterator.hasNext()) {
            Copier from = (Copier)i.next();
            Copier to = (Copier)iterator.next();
            to.copy(from);
        }
    }

    public static <K> void makeAuditableCopies(Map<K, Copier> aFormMap, Map<K, Copier> aToMap, Auditable aAuditable) {
        if (aFormMap == null || aToMap == null) {
            return;
        }
        for (Map.Entry<K, Copier> entry : aFormMap.entrySet()) {
            K fromKey = entry.getKey();
            if (aToMap.containsKey(fromKey)) {
                Copier to = aToMap.get(fromKey);
                to.copy(entry.getValue());
                if (aAuditable == null || !(to instanceof Auditable)) continue;
                AbstractAuditable.copy(aAuditable, (Auditable)((Object)to));
                continue;
            }
            Copier from = aFormMap.get(fromKey);
            if (aAuditable != null && from instanceof Auditable) {
                AbstractAuditable.copy(aAuditable, (Auditable)((Object)from));
            }
            aToMap.put(fromKey, from);
        }
    }

    public static <T> Collection<T> sortByJavaBeanProperty(String propertyName, Collection<T> aCollection) {
        return Organizer.sortByJavaBeanProperty(propertyName, aCollection, false);
    }

    public static <K, V> Map<K, V> sortByValue(Map<K, V> map, BeanComparator beanComparator) {
        return map.entrySet().stream().sorted(Map.Entry.comparingByValue(beanComparator)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    public static <T> Collection<T> sortByJavaBeanProperty(String propertyName, Collection<T> collection, boolean descending) {
        if (collection == null) {
            return new ArrayList();
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName required in Organizer");
        }
        BeanComparator bc = new BeanComparator(propertyName, descending);
        return bc.sort(collection);
    }

    public static <T> Set<T> constructSortedSetForProperty(Collection<T> aCollection, String aPropertyName) {
        if (aCollection == null || aCollection.isEmpty()) {
            return null;
        }
        TreeSet set = new TreeSet();
        Iterator<T> iterator = aCollection.iterator();
        while (iterator.hasNext()) {
            T t;
            T bean = t = iterator.next();
            set.add(JavaBean.getProperty(bean, aPropertyName));
        }
        return set;
    }

    public static Collection<Object> filterByJavaBeanProperty(List<Object> list, String propertyName, Comparable<Object> aValue) {
        logger.debug("In Organizer filtering: " + propertyName + " for value: " + aValue);
        try {
            if (list == null) {
                throw new IllegalArgumentException("aCollection required in filterByJavaBeanProperty");
            }
            ArrayList<Object> filteredList = new ArrayList<Object>(list.size());
            Iterator<Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object;
                Object bean = object = iterator.next();
                Object beanPropertyValue = JavaBean.getProperty(bean, propertyName);
                logger.debug("Got propertyValue: " + beanPropertyValue + " for propertyName: " + propertyName);
                if (aValue.compareTo(beanPropertyValue) != 0) continue;
                filteredList.add(bean);
                logger.debug("Organizer added bean");
            }
            filteredList.trimToSize();
            return filteredList;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public static Collection<Object> filterByJavaBeanDateProperty(List<Object> list, String propertyName, Comparable<Object> startComparable, Comparable<Object> endComparable) {
        logger.debug("In Organizer filtering: " + propertyName + " for date value between : " + startComparable + " and " + endComparable);
        try {
            if (list == null) {
                throw new IllegalArgumentException("aCollection required in filterByJavaBeanProperty");
            }
            ArrayList<Object> filteredList = new ArrayList<Object>(list.size());
            Iterator<Object> i = list.iterator();
            while (i.hasNext()) {
                try {
                    Object bean = i.next();
                    Object beanPropertyValue = JavaBean.getProperty(bean, propertyName);
                    SimpleDateFormat format = new SimpleDateFormat(Config.settings().getProperty("document.date.format"));
                    Date propDate = format.parse(beanPropertyValue.toString());
                    Date aDate = format.parse(startComparable.toString());
                    Date bDate = format.parse(endComparable.toString());
                    if (!propDate.after(aDate) || !propDate.before(bDate)) continue;
                    filteredList.add(bean);
                }
                catch (Exception e) {
                    logger.debug("error occurred : " + e);
                }
            }
            filteredList.trimToSize();
            return filteredList;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public static Collection<Object> filterByJavaBeanPageProperty(ArrayList<Object> aList, String aPropertyName, int fromIndex, int toIndex) {
        logger.debug("In Organizer filtering: " + aPropertyName);
        try {
            if (aList == null) {
                throw new IllegalArgumentException("aCollection required in filterByJavaBeanProperty");
            }
            ArrayList<Object> filteredList = new ArrayList<Object>(aList.size());
            Iterator<Object> i = aList.iterator();
            while (i.hasNext()) {
                try {
                    Object bean = i.next();
                    Object beanPropertyValue = JavaBean.getProperty(bean, aPropertyName);
                    int beanPropIntVal = Integer.parseInt(beanPropertyValue.toString());
                    if (fromIndex > beanPropIntVal || beanPropIntVal > toIndex) continue;
                    filteredList.add(bean);
                }
                catch (Exception e) {
                    logger.debug("error occurred : " + e);
                }
            }
            filteredList.trimToSize();
            return filteredList;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public static Map<Integer, NumberedProperty> constructNumberedPropertyMap(Collection<NumberedProperty> numberedProperties) {
        if (numberedProperties == null) {
            throw new IllegalArgumentException("aNumberedProperties required in Organizer");
        }
        HashMap<Integer, NumberedProperty> map = new HashMap<Integer, NumberedProperty>(numberedProperties.size());
        Iterator<NumberedProperty> iterator = numberedProperties.iterator();
        while (iterator.hasNext()) {
            NumberedProperty property;
            NumberedProperty numberedProperty = property = iterator.next();
            map.put(numberedProperty.getNumber(), numberedProperty);
        }
        return map;
    }

    public static Map<String, Property> constructPropertyMap(Collection<Property> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties required in Organizer");
        }
        HashMap<String, Property> map = new HashMap<String, Property>(properties.size());
        for (Property property : properties) {
            map.put(property.getName(), property);
        }
        return map;
    }

    public static <K, V> Map<K, V> toMap(Collection<Mappable<K, V>> mapCollection) {
        if (mapCollection == null) {
            throw new IllegalArgumentException("mapCollection required in Organizer");
        }
        HashMap map = new HashMap(mapCollection.size());
        for (Mappable<K, V> mappable : mapCollection) {
            map.put(mappable.getKey(), mappable.getValue());
        }
        return map;
    }

    public static <K, V> Map<K, V> toMap(Mappable<K, V>[] maps) {
        if (maps == null) {
            throw new IllegalArgumentException("maps required in Organizer");
        }
        HashMap map = new HashMap(maps.length);
        for (Mappable<K, V> mappable : maps) {
            map.put(mappable.getKey(), mappable.getValue());
        }
        return map;
    }

    public static Object[] toArray(Object obj) {
        if (obj instanceof Object[]) {
            return (Object[])obj;
        }
        Object[] returnArray = new Object[]{obj};
        return returnArray;
    }

    public static Integer[] toIntegers(Object[] objects) {
        if (objects == null) {
            throw new IllegalArgumentException("aObjects required in Organizer.toIntegers");
        }
        if (objects.length < 1) {
            throw new IllegalArgumentException("aObjects.length < 1 ");
        }
        Integer[] ints = new Integer[objects.length];
        System.arraycopy(objects, 0, ints, 0, ints.length);
        return ints;
    }

    public static double[] toDoubles(List<Double> objects) {
        if (objects == null || objects.isEmpty()) {
            return null;
        }
        double[] rets = new double[objects.size()];
        for (int i = 0; i < rets.length; ++i) {
            rets[i] = objects.get(i);
        }
        return rets;
    }

    public static <T> List<T> fill(int count, T value) {
        if (value == null || count < 1) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(count);
        for (int i = 0; i < count; ++i) {
            list.add(value);
        }
        return list;
    }

    public static <T> T at(int i, T[] args) {
        if (args == null || i < 0) {
            return null;
        }
        if (i >= args.length) {
            return null;
        }
        return args[i];
    }

    public static <K, V> Map<K, V> toMap(Object ... params) {
        if (params == null || params.length == 0) {
            return null;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Object key = null;
        for (int i = 0; i < params.length; ++i) {
            if (i % 2 == 0) {
                key = params[i];
                continue;
            }
            map.put(key, params[i]);
        }
        if (params.length % 2 == 1) {
            map.put(params[params.length - 1], null);
        }
        return map;
    }

    public static <T> ArrayList<T> toArrayList(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<T> arrayList = new ArrayList<T>(list.size());
        arrayList.addAll(list);
        return arrayList;
    }

    public static <T> String[] toArrayString(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        String[] outputs = new String[collection.size()];
        int i = 0;
        for (T obj : collection) {
            outputs[i] = Text.toString(obj);
            ++i;
        }
        return outputs;
    }

    public static <T> Arranger organize(T ... list) {
        return Organizer.organizeList(Arrays.asList(list));
    }

    public static <T> Arranger organizeList(List<T> list) {
        return new Arranger(list);
    }

    public static class Arranger {
        final List<?> collection;

        public Arranger(List<?> collection) {
            this.collection = collection == null ? Collections.emptyList() : collection;
        }

        public <T> T getByIndex(int index) {
            if (index < 0 || index > this.collection.size()) {
                return null;
            }
            return (T)this.collection.get(index);
        }

        public <T> Queue<T> toQueue() {
            if (this.collection.isEmpty()) {
                return null;
            }
            LinkedBlockingQueue queue = new LinkedBlockingQueue(this.collection.size());
            queue.addAll(this.collection);
            return queue;
        }

        public int size() {
            return this.collection.size();
        }

        public <T> T[] add(T[] array) {
            ArrayList<Object> list = new ArrayList<Object>(array.length + 1);
            list.addAll(Arrays.asList(array));
            list.addAll(this.collection);
            return list.toArray(array);
        }
    }
}

