/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.util;

import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import nyla.solutions.core.data.clock.Day;
import nyla.solutions.core.data.clock.Time;
import nyla.solutions.core.data.clock.TimeInterval;
import nyla.solutions.core.data.clock.TimeSlot;

public class Scheduler {
    public static final String DATE_FORMAT = "mm/dd/yyyy";
    private static final long ZERO = 0L;
    private Timer timer = new Timer();

    public static Calendar toCalendar(Date aDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(aDate);
        return calendar;
    }

    public static Date toDateDayOfWeek(int dayOfWeek) {
        Calendar cal = Calendar.getInstance();
        cal.set(7, dayOfWeek);
        return cal.getTime();
    }

    public static long durationMS(LocalDateTime start, LocalDateTime end) {
        if (start == null || end == null) {
            return 0L;
        }
        return Duration.between(start, end).toMillis();
    }

    public static double durationSeconds(LocalDateTime start, LocalDateTime end) {
        return Duration.between(start, end).getSeconds();
    }

    public static double durationMinutes(LocalDateTime start, LocalDateTime end) {
        return Duration.between(start, end).toMinutes();
    }

    public static long durationHours(LocalDateTime start, LocalDateTime end) {
        if (start == null || end == null) {
            return 0L;
        }
        return Duration.between(start, end).toHours();
    }

    public static Collection<TimeSlot> calculateAvailableSots(Collection<TimeInterval> takenTimeSlots, Date date, int intervalSeconds, Time startTime, Time endTime) {
        Day day = new Day(date);
        Collection<TimeSlot> allTimeSlots = Scheduler.calculateTimeSots(day, intervalSeconds, startTime, endTime);
        if (takenTimeSlots == null || takenTimeSlots.isEmpty()) {
            return allTimeSlots;
        }
        TimeSlot timeSlot2 = null;
        TreeSet<TimeSlot> availableSlots = new TreeSet<TimeSlot>();
        for (TimeSlot timeSlot2 : allTimeSlots) {
            if (takenTimeSlots.contains(timeSlot2)) continue;
            availableSlots.add(timeSlot2);
        }
        return availableSlots;
    }

    public static Collection<TimeSlot> calculateTimeSots(Day day, int intervalSeconds, Time startTime, Time endTime) {
        TimeSlot startSlot;
        if (intervalSeconds < 1) {
            throw new IllegalArgumentException("interval seconds cannot be less than one");
        }
        int count = 86400 / intervalSeconds;
        ArrayList<TimeSlot> slots = new ArrayList<TimeSlot>(count);
        for (TimeSlot slot = startSlot = TimeSlot.firstSlot(day, startTime, intervalSeconds); slot != null; slot = slot.nextTimeSlot(intervalSeconds, endTime)) {
            slots.add(slot);
        }
        return slots;
    }

    public static LocalDateTime toLocalDateTime(Day day, Time time) {
        time.assignDate(LocalDateTime.of(day.getLocalDate(), time.getLocalDateTime().toLocalTime()));
        return time.getLocalDateTime();
    }

    public static Timestamp toTimestamp(LocalDateTime localDateTime) {
        return Timestamp.valueOf(localDateTime);
    }

    public static long toEpocMilliseconds(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long toEpocMilliseconds(Timestamp timestamp) {
        return timestamp.getTime();
    }

    public static Timestamp toTimestamp(long epoc) {
        return new Timestamp(epoc);
    }

    public static long toEpochTimestamp() {
        LocalDateTime now = LocalDateTime.now();
        return Timestamp.valueOf(now).getTime();
    }

    public static TimerTask toTimerTask(Runnable runnable) {
        if (runnable instanceof TimerTask) {
            return (TimerTask)runnable;
        }
        return new TimerTaskRunnerAdapter(runnable);
    }

    public static Date dateNow() {
        return new Date(System.currentTimeMillis());
    }

    public static boolean isDateOrTime(Class<?> clz) {
        if (clz == null) {
            return false;
        }
        String className = clz.getName();
        return className.matches("(java.time.Local.*|java.util.(Date|Calendar)|java.sql.(Date|Timestamp|Time|DateTime)|.*\\.Time)");
    }

    public static LocalDateTime yesterday() {
        return LocalDateTime.now().minusDays(1L);
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static Date toLocalDateTime(LocalDate date) {
        if (date == null) {
            return null;
        }
        return Date.from(date.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        ZonedDateTime zdt = ZonedDateTime.of(localDateTime, ZoneId.systemDefault());
        return new Date(zdt.toInstant().toEpochMilli());
    }

    public static LocalDate toLocalDate(Date time) {
        return time.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime tomorrow() {
        return LocalDateTime.now().plusDays(1L);
    }

    private static class TimerTaskRunnerAdapter
    extends TimerTask {
        private Runnable runnable = null;

        TimerTaskRunnerAdapter(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            this.runnable.run();
        }
    }
}

