/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.util;

import java.util.Hashtable;
import java.util.Map;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.operations.logging.Log;
import nyla.solutions.core.util.Cryption;
import nyla.solutions.core.util.Debugger;
import nyla.solutions.core.util.settings.Settings;

public class SettingsInMemory {
    public static final String CRYPTION_PREFIX = "{cryption}";
    public static final String RESOURCE_BUNDLE_NAME = "Setting";
    private final Map<Object, Object> settingMap;
    private static Settings _instance = null;
    protected transient Log logger = Debugger.getLog(SettingsInMemory.class);

    public SettingsInMemory(Map<Object, Object> map) {
        this.settingMap = map;
    }

    public String getText(String key) {
        String value = this.getText(key, "");
        if (value.length() == 0) {
            throw new SystemException("Settings property \"" + key + "\" not found in keys " + this.getSettingMap().keySet());
        }
        return value;
    }

    public String getText(Class<?> aClass, String key) {
        return this.getText(aClass.getName() + "." + key);
    }

    public String getText(Class<?> aClass, String key, String aDefault) {
        return this.getText(aClass.getName() + "." + key, aDefault);
    }

    public String getText(String key, String defaultValue) {
        String retval = null;
        retval = (String)this.getSettingMap().get(key);
        if (retval == null || retval.length() == 0) {
            return defaultValue;
        }
        if (retval.startsWith(CRYPTION_PREFIX)) {
            try {
                retval = retval.substring(CRYPTION_PREFIX.length());
                retval = new Cryption().decryptText(retval);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
        }
        return retval;
    }

    public Integer getInteger(Class<?> aClass, String key, int defaultValue) {
        return this.getInteger(aClass.getName() + ".key", defaultValue);
    }

    public Character getCharacter(Class<?> aClass, String key, char defaultValue) {
        String results = this.getText(aClass, key, "");
        if (results.length() == 0) {
            return Character.valueOf(defaultValue);
        }
        return Character.valueOf(results.charAt(0));
    }

    public Integer getInteger(String key) {
        Integer iVal = null;
        String sVal = this.getText(key);
        if (sVal != null && sVal.length() > 0) {
            iVal = Integer.valueOf(sVal);
        }
        return iVal;
    }

    public Integer getInteger(String key, int aDefault) {
        return this.getInteger(key, (Integer)aDefault);
    }

    public Integer getInteger(Class<?> cls, String key) {
        return this.getInteger(cls.getName() + "." + key);
    }

    public Integer getInteger(Class<?> cls, String key, Integer aDefault) {
        return this.getInteger(cls.getName() + "." + key, aDefault);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        Integer iVal = null;
        String sVal = this.getText(key, "");
        iVal = sVal != null && sVal.length() > 0 ? Integer.valueOf(sVal) : defaultValue;
        return iVal;
    }

    public void setStringArray(String key, String[] args) {
        this.settingMap.put(key, args);
    }

    public String[] getStringArray(String key) {
        return (String[])this.settingMap.get(key);
    }

    public Boolean getBoolean(String key) {
        Boolean bVal = null;
        String sVal = this.getText(key);
        if (sVal != null && sVal.length() > 0) {
            bVal = Boolean.valueOf(sVal);
        }
        return bVal;
    }

    public Boolean getBoolean(String key, Boolean aBool) {
        Boolean bVal = null;
        String sVal = this.getText(key);
        bVal = sVal != null && sVal.length() > 0 ? Boolean.valueOf(sVal) : aBool;
        return bVal;
    }

    public Boolean getBoolean(Class<?> aClass, String key, boolean aBool) {
        return this.getBoolean(aClass.getName() + "." + key, aBool);
    }

    public Boolean getBoolean(String key, boolean aBool) {
        Boolean bVal = null;
        String sVal = this.getText(key);
        bVal = sVal != null && sVal.length() > 0 ? Boolean.valueOf(sVal) : Boolean.valueOf(aBool);
        return bVal;
    }

    public Long getLong(String key) {
        Long longValue = null;
        String sVal = this.getText(key);
        if (sVal != null && sVal.length() > 0) {
            longValue = Long.valueOf(sVal);
        }
        return longValue;
    }

    public Long getLong(String key, long aDefault) {
        return this.getLong(key, (Long)aDefault);
    }

    public Long getLong(String key, Long aDefault) {
        Long longValue = null;
        String sVal = this.getText(key);
        longValue = sVal != null && sVal.length() > 0 ? Long.valueOf(sVal) : aDefault;
        return longValue;
    }

    public static final synchronized Settings getSingletonInstance() {
        return _instance;
    }

    protected <K, V> Map<K, V> getSettingMap() {
        Hashtable<Object, Object> prop = new Hashtable<Object, Object>();
        prop.putAll(this.settingMap);
        return prop;
    }

    public void setProperty(Object key, Object value) {
        this.settingMap.put(key, value);
    }
}

