/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import nyla.solutions.core.data.Textable;
import nyla.solutions.core.exception.FormatException;
import nyla.solutions.core.exception.RequiredException;
import nyla.solutions.core.exception.SetupException;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.io.IO;
import nyla.solutions.core.operations.ClassPath;
import nyla.solutions.core.patterns.decorator.BasicTextStyles;
import nyla.solutions.core.patterns.decorator.TextStyles;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.Debugger;
import nyla.solutions.core.util.Organizer;
import nyla.solutions.core.util.Scheduler;

public class Text {
    public static final String TEMPLATE_DIR_PROP_NM = Text.class.getName() + ".template.dir";
    public static final String TEMPLATE_EXTENSION_PROP_NM = Text.class.getName() + ".template.extension";
    public static final String TEMPLATE_EXTENSION = Config.settings().getProperty(TEMPLATE_EXTENSION_PROP_NM, ".txt");
    public static final String TEMPLATE_CLASSPATH_ROOT = Config.settings().getProperty(Text.class, "TEMPLATE_CLASSPATH_ROOT", "templates");
    public static final String NOT = "${NOT}";
    public static final String OR = "${OR}";
    public static final String TEMPLATE_LOCALE_COUNTRY = Text.class.getName() + ".TEMPLATE_LOCALE_COUNTRY";
    public static final String TEMPLATE_LOCALE_LANGUAGE = Text.class.getName() + ".TEMPLATE_LOCALE_LANGUAGE";
    public static final String SPECIAL_START = "${START}";
    public static final String SPECIAL_END = "${END}";
    public static final String DATETIME_FORMAT = Config.settings().getProperty(Text.class, "dateFormat", "M/dd/yyyy hh:mm:ss:SS a");
    public static final String DATE_FORMAT = Config.settings().getProperty(Text.class, "dateFormat", "M/dd/yyyy");
    private static final Random random = new Random(Calendar.getInstance().getTime().getTime());
    private static final String[] fixedNumberPrefixLookup = new String[]{"0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000", "0000000000"};
    private static final String AND = "${AND}";
    private static TextStyles textStyles = null;

    public static String appendNewLine(String text) {
        String newline = IO.newline();
        if (text == null || text.isEmpty()) {
            return newline;
        }
        StringBuilder sb = new StringBuilder(text);
        if (!text.endsWith(newline)) {
            sb.append(newline);
        }
        return sb.toString();
    }

    public static TextStyles getTextStyles() {
        if (textStyles == null) {
            String className = Config.settings().getProperty(Text.class, "textStyles", BasicTextStyles.class.getName());
            try {
                textStyles = (TextStyles)ClassPath.newInstance(className);
            }
            catch (Exception e) {
                throw new SetupException("Unable to create TextStyles instance:" + className, e);
            }
        }
        return textStyles;
    }

    public static String fixedLength(int number, int length) {
        String numberText = String.valueOf(number);
        int numberLength = numberText.length();
        StringBuilder sb = new StringBuilder();
        if (length > 16) {
            sb.ensureCapacity(length);
        }
        sb.append(numberText);
        if (length == numberLength) {
            return sb.toString();
        }
        if (numberLength > length) {
            sb.setLength(length);
            return sb.toString();
        }
        int diff = length - numberLength;
        if (diff < fixedNumberPrefixLookup.length) {
            sb.insert(0, fixedNumberPrefixLookup[diff - 1]);
            return sb.toString();
        }
        for (int i = 0; i < length - numberLength; ++i) {
            sb.insert(0, "0");
        }
        return sb.toString();
    }

    public static String fixedLength(String text, int length) {
        StringBuilder sb = new StringBuilder(length);
        sb.append(text);
        sb.setLength(length);
        return sb.toString();
    }

    public static String fixedLength(String text, int length, char fillChar) {
        int originalLength;
        StringBuilder sb = new StringBuilder(length);
        sb.append(text);
        sb.setLength(length);
        if (fillChar != '\u0000' && (originalLength = text.length()) < sb.length()) {
            String newEnd = sb.substring(originalLength, sb.length()).replace('\u0000', fillChar);
            sb = sb.replace(originalLength, sb.length(), newEnd);
        }
        return sb.toString();
    }

    public static void formatMap(Map<Object, Object> map) throws FormatException {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            String text;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof String) || !(text = (String)value).contains("${")) continue;
            map.put(key, Text.format(text, map));
        }
    }

    public static String generateId() {
        Date date = Calendar.getInstance().getTime();
        String dateId = Text.formatDate("yyyyMMddHHmmssSS", date);
        return dateId + random.nextInt();
    }

    public static String newlineToCrLf(String s) {
        String s1 = s.replaceAll("\\r", "");
        return s1.replaceAll("\\n", "\r\n");
    }

    public static Set<String> toSet(String[] lines) {
        return new TreeSet<String>(Arrays.asList(lines));
    }

    public static String removeNewLines(String text) {
        return Text.replace("\r\n", " ", text);
    }

    public static Object toObject(String aValue, String aType) {
        if ("Date".equalsIgnoreCase(aType)) {
            return Text.toDate(aValue);
        }
        if ("Boolean".equalsIgnoreCase(aType)) {
            return Boolean.valueOf(aValue);
        }
        if ("Int".equalsIgnoreCase(aType) || "Integer".equalsIgnoreCase(aType)) {
            return Integer.valueOf(aValue);
        }
        if ("Double".equalsIgnoreCase(aType)) {
            return Double.valueOf(aValue);
        }
        return aValue;
    }

    public static String replaceForRegExprWith(String text, String re, String replaceText) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        Pattern pattern = Pattern.compile(re);
        return pattern.matcher(text).replaceAll(replaceText);
    }

    public static String parseRE(String text, String startRE, String endRE) {
        try {
            if (text == null || text.isEmpty()) {
                return text;
            }
            if (startRE == null || endRE == null) {
                return text;
            }
            Pattern startPattern = Pattern.compile(startRE);
            Pattern endPattern = Pattern.compile(endRE);
            Matcher startMatcher = startPattern.matcher(text);
            if (!startMatcher.find()) {
                return text;
            }
            int startIndex = startMatcher.end();
            String endText = text.substring(startIndex);
            Matcher endMatcher = endPattern.matcher(endText);
            if (!endMatcher.find()) {
                return text.substring(startIndex);
            }
            int endIndex = endMatcher.start();
            if (endIndex < 0) {
                endIndex = endText.length() - 1;
            }
            return text.substring(startIndex, startIndex + endIndex);
        }
        catch (IllegalStateException e) {
            throw new SystemException("startRE=" + startRE + " endRE=" + endRE + " text=" + text + " " + Debugger.stackTrace(e));
        }
    }

    public static String replaceFirstRegExpWith(String text, String re, String replacement) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        Pattern pattern = Pattern.compile(re);
        return pattern.matcher(text).replaceFirst(replacement);
    }

    public static String[] toStrings(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Collection) {
            return Text.toStrings((Collection)object);
        }
        if (object instanceof Object[]) {
            return Text.toStrings(Arrays.asList((Object[])object));
        }
        return new String[]{object.toString()};
    }

    public static String[] toStrings(Collection<Object> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        String[] texts = new String[collection.size()];
        int i = 0;
        for (Object obj : collection) {
            texts[i] = String.valueOf(obj);
            ++i;
        }
        return texts;
    }

    public static Collection<String> toUpperCase(Collection<String> collection) {
        Function<String, String> function = text -> text != null ? text.toUpperCase() : text;
        return Text.transform(function, collection);
    }

    public static Collection<String> transformTexts(Function<String, String> function, String ... collection) {
        return Text.transform(function, Arrays.asList(collection));
    }

    public static Collection<String> transform(Function<String, String> function, Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return collection;
        }
        ArrayList<String> list = new ArrayList<String>(collection.size());
        for (String string : collection) {
            list.add(function.apply(string));
        }
        return list;
    }

    public static <T> String toText(Collection<T> collection, String separator) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        if (separator == null) {
            separator = "";
        }
        StringBuilder sb = new StringBuilder();
        Object object = null;
        for (T t : collection) {
            object = t;
            if (object == null) continue;
            if (!sb.isEmpty()) {
                sb.append(separator);
            }
            sb.append((Object)object);
        }
        return sb.toString();
    }

    public static String[] splitRE(String text, String re) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        if (re == null) {
            throw new RequiredException("regular expression");
        }
        return text.split(re);
    }

    public static String[] split(String aText) {
        if (aText == null || aText.isEmpty()) {
            return null;
        }
        StringTokenizer toks = new StringTokenizer(aText, " \t\n\r");
        return Text.toStrings(toks);
    }

    public static String[] split(String text, String token) {
        if (text == null) {
            return null;
        }
        if (token == null) {
            return new String[]{text};
        }
        int i = text.indexOf(token);
        if (i < 0) {
            String[] results = new String[]{text};
            return results;
        }
        ArrayList<String> resultList = new ArrayList<String>(16);
        int start = 0;
        do {
            if (start == i) continue;
            resultList.add(text.substring(start, i));
        } while ((i = text.indexOf(token, start = i + token.length())) >= 0);
        if (start < text.length()) {
            resultList.add(text.substring(start, text.length()));
        }
        if (resultList.isEmpty()) {
            throw new IllegalArgumentException("Unexpected empty list");
        }
        resultList.trimToSize();
        String[] results = new String[resultList.size()];
        resultList.toArray(results);
        return results;
    }

    public static <T> T[] splitRE(String line, String re, Class<T> class1) {
        String[] text = Text.splitRE(line, re);
        if (text == null || text.length == 0) {
            return null;
        }
        Object[] results = (Object[])Array.newInstance(class1, text.length);
        for (int i = 0; i < text.length; ++i) {
            results[i] = ClassPath.newInstance(class1, text[i]);
        }
        return results;
    }

    public static String[] toStrings(StringTokenizer aTokenizer) {
        String[] texts = new String[aTokenizer.countTokens()];
        for (int i = 0; i < texts.length; ++i) {
            texts[i] = aTokenizer.nextToken();
            if (texts[i] == null) continue;
            texts[i] = texts[i].trim();
        }
        return texts;
    }

    public static Date toDate(String text) {
        return Text.toDate(text, DATE_FORMAT);
    }

    public static Date toDate(String aText, String dateFormat) {
        try {
            if (aText == null || aText.isEmpty()) {
                throw new IllegalArgumentException("aText required in toDate");
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
            return simpleDateFormat.parse(aText);
        }
        catch (ParseException e) {
            Debugger.printWarn(e);
            return null;
        }
    }

    private static int indexOf(String aContent, String aSearchText, int aFromIndex) {
        if (SPECIAL_START.equals(aSearchText)) {
            return aFromIndex;
        }
        if (SPECIAL_END.equals(aSearchText)) {
            return aContent.length();
        }
        return aContent.indexOf(aSearchText, aFromIndex);
    }

    private static int indexOf(String content, String searchText) {
        return Text.indexOf(content, searchText, 0);
    }

    public static String parseText(String aContent, String aStart, String aEnd) {
        Collection<String> results = Text.parse(aContent, aStart, aEnd);
        if (results == null || results.isEmpty()) {
            return "";
        }
        return results.iterator().next().toString();
    }

    public static String parseText(Reader aContent, String aStart, String aEnd) throws IOException {
        Collection<Object> results = Text.parse(aContent, aStart, aEnd);
        if (results == null || results.isEmpty()) {
            return "";
        }
        return results.iterator().next().toString();
    }

    public static Collection<String> parse(String aContent, String aStart, String aEnd) {
        if ((aStart == null || aStart.isEmpty()) && (aEnd == null || aEnd.isEmpty())) {
            return Arrays.asList(aContent);
        }
        return Text.parse(aContent, aStart, aEnd, false);
    }

    public static Collection<Object> parse(Reader aContent, String aStart, String aEnd) throws IOException {
        return Text.parse(aContent, aStart, aEnd, false);
    }

    public static Collection<String> parse(String content, String start, String end, boolean ignoreCase) {
        int endText;
        String compareContent;
        if (ignoreCase) {
            compareContent = content.toUpperCase();
            start = start.toUpperCase();
            end = end.toUpperCase();
        } else {
            compareContent = content;
        }
        ArrayList<String> results = new ArrayList<String>(10);
        int indexOfHref = Text.indexOf(compareContent, start);
        int startText = indexOfHref + start.length();
        if (SPECIAL_START.equals(start)) {
            startText = 0;
        }
        if ((endText = Text.indexOf(content, end, startText)) == content.length() && startText == 0) {
            results.add(content);
            return results;
        }
        String txt = null;
        while (startText > -1 && endText >= startText) {
            txt = content.substring(startText, endText);
            results.add(txt);
            indexOfHref = Text.indexOf(compareContent, start, endText);
            if (indexOfHref < 0) break;
            startText = indexOfHref + start.length();
            endText = Text.indexOf(content, end, startText);
        }
        return results;
    }

    public static Collection<Object> parse(Reader reader, String start, String end, boolean ignoreCase) throws IOException {
        String content;
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        ArrayList<Object> results = new ArrayList<Object>();
        block0: while ((content = bufferedReader.readLine()) != null) {
            int endText;
            String compareContent;
            if (ignoreCase) {
                compareContent = content.toUpperCase();
                start = start.toUpperCase();
                end = end.toUpperCase();
            } else {
                compareContent = content;
            }
            int indexOfHref = Text.indexOf(compareContent, start);
            int startText = indexOfHref + start.length();
            if (SPECIAL_START.equals(start)) {
                startText = 0;
            }
            if ((endText = Text.indexOf(content, end, startText)) == content.length() && startText == 0) {
                results.add(content);
                return results;
            }
            while (startText > -1 && endText >= startText) {
                String txt = content.substring(startText, endText);
                results.add(txt);
                indexOfHref = Text.indexOf(compareContent, start, endText);
                if (indexOfHref < 0) continue block0;
                startText = indexOfHref + start.length();
                endText = Text.indexOf(content, end, startText);
            }
        }
        return results;
    }

    protected static boolean matchesRE(String re, Object aValue) {
        if (aValue == null) {
            return false;
        }
        if (re.contains("(")) {
            if (re.indexOf(")") < 0) {
                re = re + ")";
            }
        } else if (re.indexOf(")") > -1) {
            re = "(" + re;
        }
        Pattern pattern = Pattern.compile(re, 32);
        Matcher matcher = pattern.matcher(Text.toString(aValue));
        return matcher.matches();
    }

    public static int indexOfRegExp(String text, String regExp) {
        Pattern amountsPattern = Pattern.compile(regExp);
        Matcher matcher = amountsPattern.matcher(text);
        if (matcher.find()) {
            return matcher.start();
        }
        return -1;
    }

    public static String grepText(String matchRegExp, String text) {
        if (text == null || matchRegExp == null) {
            return "";
        }
        StringTokenizer tok = new StringTokenizer(text, "\r\n");
        Pattern p = Pattern.compile(matchRegExp);
        while (tok.hasMoreTokens()) {
            String line = tok.nextToken();
            if (!p.matcher(line).find()) continue;
            return line;
        }
        return "";
    }

    public static Collection<String> grepAllTexts(String matchRegExp, String text) {
        if (text == null || matchRegExp == null) {
            return null;
        }
        String[] words = text.split("[ \t\n]");
        if (words == null || words.length == 0) {
            return null;
        }
        Pattern p = Pattern.compile(matchRegExp);
        List<String> wordsList = Arrays.asList(words);
        List<String> results = wordsList.parallelStream().filter(word -> p.matcher(word.trim()).find()).collect(Collectors.toList());
        if (results == null || results.isEmpty()) {
            return null;
        }
        return results;
    }

    public static boolean isNull(String str) {
        return str == null || str.trim().isEmpty() || "null".equals(str.trim());
    }

    public static String initCaps(String aText) {
        if (Text.isNull(aText)) {
            return aText;
        }
        boolean needInitUpper = true;
        boolean first = true;
        StringBuilder results = new StringBuilder();
        for (int i = 0; i < aText.length(); ++i) {
            char textChar = aText.charAt(i);
            if (!Character.isWhitespace(textChar) && needInitUpper) {
                needInitUpper = false;
                first = false;
                textChar = Character.toUpperCase(textChar);
            } else if (!Character.isWhitespace(textChar) && !needInitUpper) {
                textChar = Character.toLowerCase(textChar);
            } else if (!first && Character.isWhitespace(textChar)) {
                needInitUpper = true;
            }
            results.append(textChar);
        }
        return results.toString();
    }

    public static String toByteText(byte[] aByte) {
        if (aByte == null) {
            return "";
        }
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < aByte.length; ++i) {
            text.append(Byte.toString(aByte[i]));
            if (i + 1 >= aByte.length) continue;
            text.append(" ");
        }
        return text.toString();
    }

    public static byte[] toBytesFromByteText(String aByteText) {
        if (aByteText == null) {
            return new byte[0];
        }
        StringTokenizer tok = new StringTokenizer(aByteText);
        byte[] bytes = new byte[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            bytes[i] = Byte.valueOf(tok.nextToken());
            ++i;
        }
        return bytes;
    }

    public static String formatCurrency(String doubleText) {
        if (doubleText == null || doubleText.isEmpty()) {
            return "";
        }
        return Text.formatCurrency(Double.valueOf(doubleText));
    }

    public static String formatCurrency(double number) {
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance();
        return numberFormat.format(number);
    }

    public static String formatDouble(String aNumber) {
        return Text.formatDouble(aNumber, "#,##0.0###");
    }

    public static String formatDouble(String number, String format) {
        if (number == null || number.isEmpty()) {
            return "";
        }
        return Text.formatDouble(Double.valueOf(number), format);
    }

    public static String formatDouble(double number) {
        return Text.formatDouble(number, "#,##0.0###");
    }

    public static String formatDouble(double number, String format) {
        DecimalFormat decimalFormat = new DecimalFormat(format);
        return decimalFormat.format(number);
    }

    public static String formatNumber(String aNumber) {
        return Text.formatDouble(aNumber);
    }

    public static String formatNumber(double number) {
        return Text.formatDouble(number);
    }

    public static String formatNumber(double number, String format) {
        return Text.formatDouble(number, format);
    }

    public static String formatPercent(String number) {
        if (number == null || number.isEmpty()) {
            return "";
        }
        return Text.formatPercent(Double.valueOf(number));
    }

    public static String formatPercent(double number) {
        return Text.formatNumber(number, "###.##'%'");
    }

    public static boolean matches(String sourceValue, String complexRegularExpression) {
        if (sourceValue == null) {
            return complexRegularExpression == null;
        }
        try {
            int startOrIndex = complexRegularExpression.indexOf(OR);
            if (startOrIndex > -1) {
                if (startOrIndex == 0 && !Text.matches(sourceValue, complexRegularExpression.substring(OR.length(), complexRegularExpression.length()))) {
                    return false;
                }
                int endIndex = startOrIndex + OR.length();
                String leftExpr = complexRegularExpression.substring(0, startOrIndex);
                String rightExpr = complexRegularExpression.substring(endIndex, complexRegularExpression.length());
                return Text.matches(sourceValue, leftExpr) || Text.matches(sourceValue, rightExpr);
            }
            int startAndIndex = complexRegularExpression.indexOf(AND);
            if (startAndIndex > -1) {
                if (startAndIndex == 0 && !Text.matches(sourceValue, complexRegularExpression.substring(AND.length(), complexRegularExpression.length()))) {
                    return false;
                }
                int endIndex = startAndIndex + AND.length();
                String leftExpr = complexRegularExpression.substring(0, startAndIndex);
                String rightExpr = complexRegularExpression.substring(endIndex, complexRegularExpression.length());
                return Text.matches(sourceValue, leftExpr) && Text.matches(sourceValue, rightExpr);
            }
            int notIndex = complexRegularExpression.indexOf(NOT);
            if (notIndex > -1) {
                String notRegExp = complexRegularExpression.substring(notIndex + NOT.length(), complexRegularExpression.length());
                return !Text.matches(sourceValue, notRegExp);
            }
        }
        catch (RuntimeException e) {
            throw new SystemException("complexRegularExpression=" + complexRegularExpression + " sourceValue=" + sourceValue + " " + Debugger.stackTrace(e));
        }
        return Text.matchesRE(complexRegularExpression, sourceValue);
    }

    public static String replace(String aOld, String aNew, String aInput) {
        if (aOld == null || aNew == null || aInput == null) {
            return aInput;
        }
        int i = aInput.indexOf(aOld);
        if (i < 0) {
            return aInput;
        }
        StringBuilder sb = new StringBuilder();
        int start = 0;
        do {
            if (start != i) {
                sb.append(aInput.substring(start, i));
            }
            sb.append(aNew);
        } while ((i = aInput.indexOf(aOld, start = i + aOld.length())) >= 0);
        if (start < aInput.length()) {
            sb.append(aInput.substring(start, aInput.length()));
        }
        return sb.toString();
    }

    public static String toRomanNumber(int input) {
        if (input > 0 && input < 40000) {
            StringBuilder strValue = new StringBuilder();
            String[] roNumStr = new String[]{"I", "IV", "V", "IX", "X", "XL", "L", "XC", "C", "CD", "D", "CM", "M", "ME", "E", "MG", "G"};
            int[] roNumInt = new int[]{1, 4, 5, 9, 10, 40, 50, 90, 100, 400, 500, 900, 1000, 4000, 5000, 9000, 10000};
            for (int i = roNumStr.length - 1; i >= 0; --i) {
                while (input >= roNumInt[i]) {
                    input -= roNumInt[i];
                    strValue.append(roNumStr[i]);
                }
            }
            return strValue.toString();
        }
        return " ";
    }

    public static int toIntegerFromRoman(String input, boolean valid) {
        if (input == null) {
            return 0;
        }
        if (valid) {
            int intValue = 0;
            char[] roNumStr = new char[]{'I', 'V', 'X', 'L', 'C', 'D', 'M', 'E', 'G'};
            int[] roNumInt = new int[]{1, 5, 10, 50, 100, 500, 1000, 5000, 10000};
            block0: for (int i = input.length() - 1; i >= 0; --i) {
                for (int j = roNumStr.length - 1; j >= 0; --j) {
                    if (input.charAt(i) != roNumStr[j]) continue;
                    intValue += roNumInt[j];
                    if (i >= input.length() - 1 || j >= roNumStr.length - 1 || j % 2 != 0 || input.charAt(i + 1) != roNumStr[j + 1] && input.charAt(i + 1) != roNumStr[j + 2]) continue block0;
                    intValue -= roNumInt[j] * 2;
                    continue block0;
                }
            }
            return intValue;
        }
        return 0;
    }

    public static InputStream toInputStream(String aInput) {
        if (aInput == null) {
            return null;
        }
        return new BufferedInputStream(new ByteArrayInputStream(aInput.getBytes(IO.CHARSET)));
    }

    public static String format(String aBindText, Object aBindMap) throws FormatException {
        return Text.format(aBindText, aBindMap, DATE_FORMAT);
    }

    public static String formatArray(String bindText, Object[] inputs) throws FormatException {
        if (inputs == null) {
            return bindText;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < inputs.length; ++i) {
            map.put(String.valueOf(i), inputs[i]);
        }
        return Text.format(bindText, map);
    }

    public static String formatDate(LocalDate date) {
        return Text.formatDate(date, DATE_FORMAT);
    }

    public static String formatDate(LocalDateTime date) {
        return Text.formatDate(date, DATE_FORMAT);
    }

    public static String formatDate(TemporalAccessor date, String format) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return formatter.format(date);
    }

    public static String formatDate(Date date) {
        return Text.formatDate(DATE_FORMAT, date);
    }

    public static String formatDate(Calendar date) {
        if (date == null) {
            return "";
        }
        return Text.formatDate(DATE_FORMAT, date.getTime());
    }

    public static String formatDate(String format, LocalDate date) {
        return Text.formatDate(format, Scheduler.toLocalDateTime(date));
    }

    public static String formatDate(String format, Date date) {
        if (date == null) {
            return "";
        }
        if (format == null || format.isEmpty()) {
            return date.toString();
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static String formatDate(String text) {
        return Text.formatDate(DATE_FORMAT, Text.toDate(text));
    }

    public static String formatFromTemplate(String aTemplateName, Map<Object, Object> aBindMap, Locale aLocale) throws IOException {
        return Text.format(Text.loadTemplate(aTemplateName, aLocale), aBindMap);
    }

    public static String format(String bindText, Object bindObj, String dateFormat) throws FormatException {
        return Text.getTextStyles().format(bindText, bindObj, dateFormat);
    }

    public static String formatMap(String bindText, Map<String, String> map) throws FormatException {
        return Text.format(bindText, map);
    }

    public static String formatMap(String bindText, Object ... keyValues) throws FormatException {
        return Text.format(bindText, Organizer.toMap(keyValues));
    }

    public static void formatWriter(String text, Object aBindMap, Writer writer) throws IOException, FormatException {
        Text.formatWriter(text, aBindMap, null, writer);
    }

    public static void formatWriter(String text, Object aBindMap, String dateFormat, Writer writer) throws IOException, FormatException {
        Text.getTextStyles().formatWriter(text, aBindMap, dateFormat, writer);
    }

    public static void formatWriterFromTemplateName(String templateName, Object aBindMap, Writer writer) throws IOException, FormatException {
        Text.getTextStyles().formatWriter(new File(Config.settings().getProperty(TEMPLATE_DIR_PROP_NM)), templateName, aBindMap, null, writer);
    }

    public static void formatWriter(File templateDir, String templateName, Object aBindMap, String dateFormat, Writer writer) throws IOException, FormatException {
        Text.getTextStyles().formatWriter(templateDir, templateName, aBindMap, dateFormat, writer);
    }

    public static boolean strCompare(String str1, String str2) {
        boolean isEqual = false;
        if (str1 == null && str2 == null) {
            isEqual = true;
        } else if (str1 != null && str2 == null) {
            isEqual = false;
        } else if (str1 == null && str2 != null) {
            isEqual = false;
        } else {
            if (str1 == null) {
                return false;
            }
            isEqual = str1.equals(str2);
        }
        return isEqual;
    }

    public static String loadTemplate(String templateName) throws IOException {
        return Text.loadTemplate(templateName, null);
    }

    public static String loadTemplate(String templateName, Locale locale) throws IOException {
        String templateDir;
        if (templateName == null) {
            throw new IllegalArgumentException("aTemplateNM, aLocale required in Text");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        if (Text.isNull(country)) {
            country = Config.settings().getProperty(TEMPLATE_LOCALE_COUNTRY, Locale.getDefault().getCountry());
        }
        if (Text.isNull(lang)) {
            lang = Config.settings().getProperty(TEMPLATE_LOCALE_LANGUAGE, Locale.getDefault().getLanguage());
        }
        if (!(templateDir = Config.settings().getProperty(TEMPLATE_DIR_PROP_NM, "")).isEmpty()) {
            StringBuilder templatePath = new StringBuilder(templateDir).append("/").append(templateName);
            File file = new File(templatePath.toString());
            if (!file.exists()) {
                templatePath.append("_").append(country.toLowerCase()).append("_").append(lang.toLowerCase()).append(Config.settings().getProperty(TEMPLATE_EXTENSION_PROP_NM, ".txt"));
            }
            return IO.readFile(templatePath.toString());
        }
        String path = TEMPLATE_CLASSPATH_ROOT + "/" + templateName + TEMPLATE_EXTENSION;
        return IO.readClassPath(path);
    }

    public static int digitCount(String val) {
        if (val == null) {
            return 0;
        }
        int c = 0;
        for (int i = 0; i < val.length(); ++i) {
            if (!Character.isDigit(val.charAt(i))) continue;
            ++c;
        }
        return c;
    }

    public static int characterCount(char character, String text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        int c = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != character) continue;
            ++c;
        }
        return c;
    }

    public static boolean isInteger(String val) {
        if (val == null || val.isEmpty()) {
            return false;
        }
        val = val.trim();
        for (int i = 0; i < val.length(); ++i) {
            if (Character.isDigit(val.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String toString(Object aObject) {
        if (aObject == null) {
            return "";
        }
        if (aObject instanceof Date) {
            return Text.formatDate((Date)aObject);
        }
        if (aObject instanceof Calendar) {
            return Text.formatDate((Calendar)aObject);
        }
        if (aObject instanceof Object[]) {
            Object[] objects = (Object[])aObject;
            StringBuilder text = new StringBuilder();
            for (int i = 0; i < objects.length; ++i) {
                if (i != 0) {
                    text.append(",");
                }
                text.append(objects[i]);
            }
            return text.toString();
        }
        if (aObject instanceof Textable) {
            return ((Textable)aObject).getText();
        }
        if (aObject instanceof byte[]) {
            return new String((byte[])aObject, IO.CHARSET);
        }
        if (aObject instanceof InputStream) {
            try {
                return IO.readText((InputStream)aObject, true);
            }
            catch (IOException e) {
                throw new SystemException(Debugger.stackTrace(e));
            }
        }
        return aObject.toString();
    }

    public static boolean isNumber(Object aObject) {
        if (aObject instanceof Number) {
            return true;
        }
        if (aObject == null) {
            return false;
        }
        String text = aObject.toString().trim();
        if (text.isEmpty()) {
            return false;
        }
        try {
            Double.parseDouble(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static <T> String mergeArray(String separator, T[] merging) {
        if (merging == null || merging.length == 0) {
            return null;
        }
        StringBuilder text = new StringBuilder();
        if (separator == null) {
            separator = "";
        }
        for (T merge : merging) {
            if (!text.isEmpty() && separator != null) {
                text.append(separator);
            }
            text.append(merge);
        }
        return text.toString();
    }

    public static String merge(String separator, Object ... merging) {
        return Text.mergeArray(separator, merging);
    }

    public static String formatTextFromClassPath(String path, Map<?, ?> map) throws IOException {
        String template = IO.readClassPath(path);
        return Text.format(template, map);
    }

    public static LocalDateTime toLocalDateTime(String text) {
        return Text.toLocalDateTime(text, DATETIME_FORMAT);
    }

    public static LocalDateTime toLocalDateTime(String text, String format) {
        try {
            DateTimeFormatter df = DateTimeFormatter.ofPattern(format);
            return LocalDateTime.parse(text, df);
        }
        catch (DateTimeParseException e) {
            throw new FormatException(e.getMessage() + " FORMAT:" + format, e);
        }
    }

    public static LocalDate toLocalDate(String text, String format) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try {
            if (format == null || format.isEmpty()) {
                format = DATE_FORMAT;
            }
            DateTimeFormatter df = DateTimeFormatter.ofPattern(format);
            return LocalDate.parse(text, df);
        }
        catch (DateTimeParseException e) {
            throw new FormatException(e.getMessage() + " FORMAT:" + format, e);
        }
    }

    public static String generateAlphabeticId(int targetStringLength) {
        int leftLimit = 97;
        int rightLimit = 122;
        Random random = new Random();
        return random.ints(leftLimit, rightLimit + 1).limit(targetStringLength).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public static String build(String ... texts) {
        if (texts.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String text : texts) {
            builder.append(text);
        }
        return builder.toString();
    }

    public static String toProperCase(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() == 1) {
            return text.toUpperCase();
        }
        return new StringBuilder(text.length()).append(Character.toString(text.charAt(0)).toUpperCase()).append(text.substring(1).toLowerCase()).toString();
    }

    public static String encodeBase64(String text) {
        return Base64.getEncoder().encodeToString(text.getBytes(IO.CHARSET));
    }

    public static String trim(String text, char character) {
        if (text == null) {
            return "";
        }
        int beginIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (character == text.charAt(i)) continue;
            beginIndex = i;
            break;
        }
        int endIndex = -1;
        for (int i = text.length() - 1; i >= 0; --i) {
            if (character == text.charAt(i)) continue;
            endIndex = i + 1;
            break;
        }
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndex < 0) {
            endIndex = text.length() - 1;
        }
        return text.substring(beginIndex, endIndex);
    }

    public static <T> String valueOf(T text, T defaultValue) {
        if (text == null) {
            return String.valueOf(defaultValue);
        }
        String textString = text.toString();
        if (textString.isEmpty() || "null".equals(textString)) {
            return String.valueOf(defaultValue);
        }
        return textString;
    }
}

