/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.util.collections;

import java.util.Arrays;
import java.util.List;
import java.util.stream.DoubleStream;

public class DimensionBuilder<T> {
    private final T[] inputs;
    private int length;
    private T fillValue;

    private DimensionBuilder(T[] inputs) {
        this.inputs = inputs;
    }

    public static <T> DimensionBuilder builder(T[] inputs) {
        return new DimensionBuilder<T>(inputs);
    }

    public static <T> DimensionBuilder builder(double[] inputs) {
        return new DimensionBuilder<Object>(DoubleStream.of(inputs).boxed().toArray());
    }

    public DimensionBuilder<T> length(int size) {
        this.length = size;
        return this;
    }

    public DimensionBuilder<T> fillValue(T fillValue) {
        this.fillValue = fillValue;
        return this;
    }

    public List<T> build() {
        if (this.length == 0) {
            return Arrays.asList(this.inputs);
        }
        if (this.length < this.inputs.length) {
            return Arrays.asList(Arrays.copyOf(this.inputs, this.length));
        }
        Object[] newArray = Arrays.copyOf(this.inputs, this.length);
        Arrays.fill(newArray, this.inputs.length, newArray.length, this.fillValue);
        return Arrays.asList(newArray);
    }
}

