/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.util.settings;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import nyla.solutions.core.exception.ConfigException;
import nyla.solutions.core.exception.ConfigLockException;
import nyla.solutions.core.io.FileMonitor;
import nyla.solutions.core.patterns.observer.SubjectObserver;
import nyla.solutions.core.patterns.observer.SubjectRegistry;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.Debugger;
import nyla.solutions.core.util.Text;
import nyla.solutions.core.util.settings.AbstractSettings;
import nyla.solutions.core.util.settings.PropertiesSupplier;
import nyla.solutions.core.util.settings.Settings;

public class ConfigSettings
extends AbstractSettings {
    private static final ReentrantLock lock = new ReentrantLock();
    private static final long lockPeriodMs = 5000L;
    private SubjectRegistry registry = new SubjectRegistry();
    private boolean mergeSystemProperties = true;
    private boolean mergeEnvProperties = true;
    private boolean setSystemProperties = false;
    private File file = null;
    private FileMonitor fileMonitor = null;
    private String configSourceLocation = null;
    private Properties properties = null;
    protected static final String registerObserver_POLLING_INTERVAL_MS_PROP = "CONFIG_FILE_WATCH_POLLING_INTERVAL_MS";
    protected static final String registerObserver_DELAY_MS_PROP = "CONFIG_FILE_WATCH_DELAY_MS";
    private long registerObserver_DELAY_MS_DEFAULT = 5000L;

    public ConfigSettings() {
    }

    public ConfigSettings(Map<Object, Object> properties) {
        this.setProperties(properties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized Map<Object, Object> getProperties() {
        if (!lock.tryLock(5000L, TimeUnit.MILLISECONDS)) throw new ConfigLockException("Setting settings");
        try {
            if (this.properties == null || this.isAlwaysReload()) {
                this.loadProperties();
            }
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>(this.properties);
            lock.unlock();
            return hashMap;
        }
        catch (Throwable throwable) {
            try {
                lock.unlock();
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new ConfigException(e);
            }
        }
    }

    @Override
    public synchronized void setProperties(Map<Object, Object> properties) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.putAll(properties);
    }

    @Override
    public void reLoad() {
        this.loadProperties();
    }

    private synchronized void loadProperties() {
        block10: {
            try {
                if (lock.tryLock(5000L, TimeUnit.MILLISECONDS)) {
                    try {
                        this.loadWithoutLock();
                        break block10;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                throw new ConfigLockException("Config settings loading");
            }
            catch (ConfigException e) {
                throw e;
            }
            catch (FileNotFoundException e) {
                throw new ConfigException(e.getMessage(), e);
            }
            catch (Exception e) {
                throw new ConfigException(e.getMessage(), e);
            }
        }
        try {
            this.registry.notify(this.getClass().getName(), this);
        }
        catch (Exception e) {
            Debugger.printWarn(e);
        }
    }

    private void loadWithoutLock() throws IOException {
        String propName;
        String useFormattingText;
        this.file = null;
        boolean alwaysReload = this.isAlwaysReload();
        boolean useFormatting = this.isUseFormatting();
        String filePath = this.getSystemPropertyFile();
        this.properties = new PropertiesSupplier(filePath).get();
        String reloadBool = this.properties.getProperty(Config.class.getName() + ".alwaysReload");
        alwaysReload = reloadBool == null || reloadBool.length() == 0 ? false : Boolean.valueOf(reloadBool);
        this.setAlwaysReload(alwaysReload);
        this.mergeSystemProperties = Boolean.valueOf(this.properties.getProperty(Config.class.getName() + ".mergeSystemProperties", "true"));
        if (this.mergeSystemProperties) {
            this.properties.putAll((Map<?, ?>)((Properties)System.getProperties().clone()));
        }
        this.mergeEnvProperties = Boolean.valueOf(this.properties.getProperty(Config.class.getName() + ".mergeEnvProperties", "true"));
        if (this.mergeEnvProperties) {
            this.properties.putAll(System.getenv());
        }
        if (useFormatting = (useFormattingText = this.properties.getProperty(propName = Config.class.getName() + ".useFormatting")) == null || useFormattingText.length() == 0 ? false : Boolean.valueOf(useFormattingText)) {
            Text.formatMap(this.properties);
        }
        propName = Config.class.getName() + ".setSystemProperties";
        this.setSystemProperties = Boolean.valueOf(this.properties.getProperty(propName, "false"));
        if (this.setSystemProperties) {
            Set<Object> keySet = this.properties.keySet();
            for (String string : keySet) {
                String sysProp = System.getProperty(string);
                if (sysProp != null && sysProp.length() > 0) continue;
                System.setProperty(string, this.properties.getProperty(string));
            }
        }
    }

    private String getSystemPropertyFile() {
        String file = System.getProperty("config.properties");
        if (file == null || file.length() == 0) {
            // empty if block
        }
        return file;
    }

    @Override
    public String getLocation() {
        return this.configSourceLocation;
    }

    @Override
    public synchronized void registerObserver(SubjectObserver<Settings> settingsObserver) {
        if (settingsObserver == null) {
            throw new IllegalArgumentException("settingsObserver is required");
        }
        if (this.file != null) {
            if (this.fileMonitor == null) {
                this.fileMonitor = new FileMonitor(this.getPropertyLong(registerObserver_POLLING_INTERVAL_MS_PROP), this.getPropertyLong(registerObserver_DELAY_MS_PROP, this.registerObserver_DELAY_MS_DEFAULT));
            }
            this.fileMonitor.monitor(this.file.getParent(), this.file.getName(), false);
            this.fileMonitor.add((observable, o) -> this.reLoad());
        }
        this.registry.register(this.getClass().getName(), settingsObserver);
    }
}

