/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.util.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import nyla.solutions.core.io.IoSupplier;
import nyla.solutions.core.util.Config;

public class PropertiesSupplier
implements IoSupplier<Properties> {
    private final String path;
    private final PathType pathType;
    private String configSourceLocation;

    public PropertiesSupplier() {
        this(null);
    }

    public PropertiesSupplier(String path) {
        this.path = path;
        this.pathType = path == null || path.length() == 0 ? PathType.CLASSPATH : ((path = path.toLowerCase()).startsWith("http:") || path.startsWith("https:") || path.startsWith("file:") ? PathType.URL : PathType.FILE);
    }

    @Override
    public Properties get() throws IOException {
        Properties properties = switch (this.pathType) {
            default -> throw new IncompatibleClassChangeError();
            case PathType.URL -> this.loadFromUrl();
            case PathType.FILE -> this.loadFromFile();
            case PathType.CLASSPATH -> this.loadFromClassPath();
        };
        return properties;
    }

    private Properties loadFromClassPath() {
        Properties properties = new Properties();
        try {
            ResourceBundle rb = ResourceBundle.getBundle("config");
            URL url = Config.class.getResource("config.properties");
            this.configSourceLocation = url != null ? url.toString() : "config.properties";
            Enumeration<String> keys = rb.getKeys();
            String key = null;
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                properties.put(key, rb.getString(key));
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return properties;
    }

    private Properties loadFromFile() throws IOException {
        File file = Paths.get(this.path, new String[0]).toFile();
        try (FileInputStream propertiesInputStream = new FileInputStream(file);){
            Properties properties = new Properties();
            properties.load(propertiesInputStream);
            this.configSourceLocation = file.getAbsolutePath();
            Properties properties2 = properties;
            return properties2;
        }
    }

    private Properties loadFromUrl() throws IOException {
        Properties properties;
        block8: {
            URL configUrl = null;
            configUrl = new URL(this.path);
            configUrl.toURI();
            InputStream propertiesInputStream = configUrl.openStream();
            try {
                Properties properties2 = new Properties();
                properties2.load(propertiesInputStream);
                this.configSourceLocation = configUrl.toString();
                properties = properties2;
                if (propertiesInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (propertiesInputStream != null) {
                        try {
                            propertiesInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MalformedURLException | URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            propertiesInputStream.close();
        }
        return properties;
    }

    static enum PathType {
        URL,
        FILE,
        CLASSPATH;

    }
}

