/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.util.stats;

import java.util.function.Consumer;
import nyla.solutions.core.util.stats.Mathematics;

public class MathematicStats
implements Consumer<Number> {
    private final int capacity;
    private final Mathematics mathematics;
    private int acceptCount = 0;
    private final Number[] values;

    public MathematicStats(int capacity, Mathematics mathematics) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Expected capacity > 0");
        }
        this.capacity = capacity;
        this.values = new Number[capacity];
        this.mathematics = mathematics;
    }

    @Override
    public void accept(Number expected) {
        this.values[this.acceptCount % this.capacity] = expected;
        ++this.acceptCount;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getAcceptCount() {
        return this.acceptCount;
    }

    public double percentile(double percential) {
        return this.mathematics.percentile(percential, this.values);
    }

    public double mean() {
        return this.mathematics.mean(this.values);
    }

    public double stdDev() {
        return this.mathematics.stdDev(this.values);
    }

    public double min() {
        return this.mathematics.min(this.values);
    }

    public double max() {
        return this.mathematics.max(this.values);
    }
}

