/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.util.stats;

import java.util.Arrays;
import java.util.List;
import nyla.solutions.core.util.stats.NullableNumberComparator;

public class Mathematics {
    private NullableNumberComparator comparator = new NullableNumberComparator();

    public double variance(Number ... a) {
        if (a.length == 0) {
            return Double.NaN;
        }
        double avg = this.mean(a);
        double sum = 0.0;
        int count = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null) continue;
            ++count;
            sum += (a[i].doubleValue() - avg) * (a[i].doubleValue() - avg);
        }
        return sum / (double)(count - 1);
    }

    public double mean(Number ... a) {
        if (a.length == 0) {
            return Double.NaN;
        }
        double sum = this.sum(a);
        return sum / (double)this.nonNullCount(a);
    }

    private long nonNullCount(Number[] a) {
        long count = 0L;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null) continue;
            ++count;
        }
        return count;
    }

    public double varp(Number ... a) {
        if (a.length == 0) {
            return Double.NaN;
        }
        double avg = this.mean(a);
        double sum = 0.0;
        int count = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null) continue;
            ++count;
            sum += (a[i].doubleValue() - avg) * (a[i].doubleValue() - avg);
        }
        return sum / (double)count;
    }

    public double stdDev(Number ... a) {
        if (a == null || a.length == 0) {
            return -1.0;
        }
        return Math.sqrt(this.varp(a));
    }

    public double stdDev(List<? extends Number> averages) {
        Number[] numbers = new Number[averages.size()];
        averages.toArray(numbers);
        return this.stdDev(numbers);
    }

    public double sum(Number ... a) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null) continue;
            sum += a[i].doubleValue();
        }
        return sum;
    }

    public double percentile(double percentile, Number ... a) {
        if (a.length == 0) {
            return Double.NaN;
        }
        long total = this.nonNullCount(a);
        int n = Math.round(Double.valueOf((double)total * (percentile / 100.0)).floatValue());
        Number[] sortCopy = Arrays.copyOf(a, a.length);
        Arrays.sort(sortCopy, this.comparator);
        return sortCopy[n - 1].doubleValue();
    }

    private void fixNulls(Number[] sortCopy, Number valueForNull) {
        for (int i = 0; i < sortCopy.length; ++i) {
            if (sortCopy[i] != null) continue;
            sortCopy[i] = valueForNull;
        }
    }

    public double min(Number ... a) {
        if (a.length == 0) {
            return 0.0;
        }
        double min = Double.NaN;
        if (a[0] != null) {
            min = a[0].doubleValue();
        }
        for (int ktr = 0; ktr < a.length; ++ktr) {
            if (a[ktr] == null) continue;
            double current = a[ktr].doubleValue();
            if (!Double.isNaN(min) && !(current < min)) continue;
            min = current;
        }
        return min;
    }

    public double max(Number ... a) {
        if (a.length == 0) {
            return 0.0;
        }
        double max = Double.NaN;
        if (a[0] != null) {
            max = a[0].doubleValue();
        }
        for (int ktr = 0; ktr < a.length; ++ktr) {
            if (a[ktr] == null) continue;
            double current = a[ktr].doubleValue();
            if (!Double.isNaN(max) && !(current > max)) continue;
            max = current;
        }
        return max;
    }
}

