/*
 * Decompiled with CFR 0.152.
 */
package com.github.obase.webc.hiido;

import com.github.obase.kit.ObjectKit;
import com.github.obase.kit.StringKit;
import com.github.obase.security.Principal;
import com.github.obase.webc.Kits;
import com.github.obase.webc.ServletMethodHandler;
import com.github.obase.webc.ServletMethodObject;
import com.github.obase.webc.Wsid;
import com.github.obase.webc.config.WebcConfig;
import com.github.obase.webc.hiido.HiidoKit;
import com.github.obase.webc.support.security.WsidServletMethodProcessor;
import com.github.obase.webc.yy.UserPrincipal;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Response;
import redis.clients.jedis.Transaction;

public abstract class HiidoauthServletMethodProcessor
extends WsidServletMethodProcessor
implements HiidoKit.Callback {
    protected abstract String getUdbApi();

    protected abstract String getAgentId();

    protected abstract byte[] getAgentPwd();

    protected abstract String getPublicKey();

    protected abstract String getHomepage();

    protected abstract String getHiidoLoginUrl();

    protected abstract JedisPool getJedisPool();

    public void setup(WebcConfig.FilterInitParam params, Map<String, ServletMethodObject> rules) throws ServletException {
        ServletMethodHandler postHiidoLoginObject = new ServletMethodHandler(){

            public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
                String token = Kits.readParam((HttpServletRequest)request, (String)"token");
                if (!HiidoauthServletMethodProcessor.this.postHiidoLogin(request, response, token)) {
                    HiidoauthServletMethodProcessor.this.sendError(response, 605, 605, "Invalid account!");
                    return;
                }
                Kits.sendRedirect((HttpServletResponse)response, (String)Kits.getServletPath((HttpServletRequest)request, (String)((String)ObjectKit.ifnull((Object)HiidoauthServletMethodProcessor.this.getHomepage(), (Object)"/"))));
            }
        };
        ServletMethodObject object = new ServletMethodObject(null, "/postHiidoLogin");
        Arrays.fill(object.handlers, postHiidoLoginObject);
        rules.put("/postHiidoLogin", object);
        super.setup(params, rules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Principal validateAndExtendPrincipal(Wsid wsid) {
        String data = null;
        try (Jedis jedis = null;){
            jedis = this.getJedisPool().getResource();
            Transaction tx = jedis.multi();
            Response resp = tx.get(wsid.id);
            tx.pexpire(wsid.id, this.timeoutMillis);
            tx.exec();
            data = (String)resp.get();
        }
        if (data != null) {
            return new UserPrincipal().decode(data);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean postHiidoLogin(HttpServletRequest request, HttpServletResponse response, String token) throws ServletException, IOException {
        if (StringKit.isEmpty((String)token)) {
            return false;
        }
        UserPrincipal principal = this.validatePrincipal(HiidoKit.getStaffInfoByToken((String)ObjectKit.ifnull((Object)this.getUdbApi(), (Object)"http://udb.hiido.com/udbApi.php"), this.getAgentId(), this.getAgentPwd(), this.getPublicKey(), token));
        if (principal == null) {
            return false;
        }
        Wsid wsid = Wsid.valueOf((String)principal.getPassport()).resetToken((long)this.wsidTokenBase);
        String data = principal.encode();
        try (Jedis jedis = null;){
            jedis = this.getJedisPool().getResource();
            jedis.psetex(wsid.id, this.timeoutMillis, data);
        }
        request.setAttribute("$_WSID", (Object)wsid);
        request.setAttribute("$_PRINCIPAL", (Object)principal);
        Kits.writeCookie((HttpServletResponse)response, (String)"wsid", (String)Wsid.encode((Wsid)wsid), (String)this.wsidDomain, (String)"/", (int)-1);
        return true;
    }

    protected void redirectLoginPage(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Kits.sendRedirect((HttpServletResponse)response, (String)((String)ObjectKit.ifnull((Object)this.getHiidoLoginUrl(), (Object)"https://portal.hiido.com")));
    }

    protected Wsid tryOssLogin(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        return null;
    }

    protected UserPrincipal validatePrincipal(UserPrincipal staffInfoByToken) {
        return staffInfoByToken;
    }

    protected boolean validatePermission(Principal principal, HttpMethod method, ServletMethodObject object) {
        return true;
    }

    public final List<Principal> getMyAgentStaffInfo() {
        return HiidoKit.getMyAgentStaffInfo((String)ObjectKit.ifnull((Object)this.getUdbApi(), (Object)"http://udb.hiido.com/udbApi.php"), this.getAgentId(), this.getAgentPwd(), this.getPublicKey());
    }

    public void updateMyStaffAgentInfo(boolean valid, String ... users) {
        HiidoKit.updateMyStaffAgentInfo((String)ObjectKit.ifnull((Object)this.getUdbApi(), (Object)"http://udb.hiido.com/udbApi.php"), this.getAgentId(), this.getAgentPwd(), this.getPublicKey(), valid, users);
    }

    public void updateMyStaffAgentInfo(Map<String, Boolean> users) {
        HiidoKit.updateMyStaffAgentInfo((String)ObjectKit.ifnull((Object)this.getUdbApi(), (Object)"http://udb.hiido.com/udbApi.php"), this.getAgentId(), this.getAgentPwd(), this.getPublicKey(), users);
    }
}

