/*
 * Decompiled with CFR 0.152.
 */
package com.github.obase.webc.udb;

import com.duowan.udb.auth.UserinfoForOauth;
import com.duowan.udb.util.codec.AESHelper;
import com.duowan.universal.login.BasicCredentials;
import com.duowan.universal.login.Credentials;
import com.duowan.universal.login.client.UniversalLoginClient;
import com.duowan.universal.login.client.YYSecCenterOpenWSInvoker;
import com.github.obase.kit.StringKit;
import com.github.obase.security.Principal;
import com.github.obase.webc.Kits;
import com.github.obase.webc.Wsid;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.LinkedList;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UdbKit {
    private static Log logger = LogFactory.getLog(UdbKit.class);
    public static final String LOOKUP_PATH_LOGIN = "/login";
    public static final String LOOKUP_PATH_LOGOUT = "/logout";
    public static final String LOOKUP_PATH_GEN_URL_TOKEN = "/genUrlToken";
    public static final String LOOKUP_PATH_CALLBACK = "/callback";
    public static final String LOOKUP_PATH_DENY_CALLBACK = "/denyCallback";
    public static final String PARAM_URL = "url";
    public static final String PARAM_SSL = "ssl";

    private UdbKit() {
    }

    public static String getRealUrl(HttpServletRequest request, String protocol, String servletPathPrefix, String lookupPath) {
        StringBuilder sb = new StringBuilder(256);
        if (protocol != null) {
            sb.append(protocol);
        }
        sb.append("//");
        sb.append(Kits.getHost((HttpServletRequest)request));
        sb.append(request.getContextPath());
        if (StringKit.isNotEmpty((String)servletPathPrefix)) {
            if (servletPathPrefix.charAt(0) != '/') {
                sb.append('/');
            }
            sb.append(servletPathPrefix);
        }
        sb.append(lookupPath);
        return sb.toString();
    }

    public static void login(HttpServletRequest request, HttpServletResponse response, String servletPathPrefix) throws Exception {
        String url = Kits.readParam((HttpServletRequest)request, (String)PARAM_URL);
        StringBuilder sb = new StringBuilder(512);
        sb.append("<!DOCTYPE html>");
        sb.append("<html>");
        sb.append("<head>");
        sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />");
        sb.append("<title>YY\u7edf\u4e00\u9a8c\u8bc1\u4e2d\u5fc3</title>");
        sb.append("<script src=\"https://res.udb.duowan.com/js/jquery-1.4.2.min.js\" type=\"text/javascript\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"https://res.udb.duowan.com/lgn/js/oauth/udbsdk/pcweb/udb.sdk.pcweb.popup.min.js\"></script>");
        sb.append("<script type=\"text/javascript\">");
        sb.append("function sdklogin(){ UDB.sdk.PCWeb.popupOpenLgn(document.location.protocol+'").append(UdbKit.getRealUrl(request, null, servletPathPrefix, LOOKUP_PATH_GEN_URL_TOKEN)).append("?ssl='+(document.location.protocol=='https:')");
        if (url != null) {
            sb.append("+'&url=").append(URLEncoder.encode(url, "UTF-8")).append("'");
        }
        sb.append(",'','');}");
        sb.append("</script>");
        sb.append("</head>");
        sb.append("<body onload=\"sdklogin();\">");
        sb.append("</body>");
        sb.append("</html>");
        Kits.writeHtml((HttpServletResponse)response, (int)200, (CharSequence)sb);
    }

    public static void genUrlToken(HttpServletRequest request, HttpServletResponse response, String servletPathPrefix, String appid, String appkey) throws IOException {
        try {
            boolean pssl = Kits.readBooleanParam((HttpServletRequest)request, (String)PARAM_SSL, (boolean)false);
            String purl = Kits.readParam((HttpServletRequest)request, (String)PARAM_URL);
            BasicCredentials cc = new BasicCredentials(appid, appkey);
            UniversalLoginClient duowan = new UniversalLoginClient((Credentials)cc);
            duowan.initialize(UdbKit.getRealUrl(request, pssl ? "https:" : "http:", servletPathPrefix, LOOKUP_PATH_CALLBACK + (StringKit.isEmpty((String)purl) ? "" : "?url=" + purl)));
            String tmpTokensecret = duowan.getTokenSecret();
            tmpTokensecret = AESHelper.encrypt((String)tmpTokensecret, (String)appkey);
            URL redirectURL = duowan.getAuthorizationURL();
            String url = redirectURL.toExternalForm() + "&denyCallbackURL=" + UdbKit.getRealUrl(request, pssl ? "https:" : "http:", servletPathPrefix, LOOKUP_PATH_DENY_CALLBACK) + "&UIStyle=qlogin&cssid=" + appid;
            StringBuilder sb = new StringBuilder(256).append("{\"success\":\"1\",\"url\":").append("\"").append(url).append("\"").append(",\"ttokensec\":").append("\"").append(tmpTokensecret).append("\"").append("}");
            Kits.writeJson((HttpServletResponse)response, (int)200, (CharSequence)sb);
        }
        catch (Exception e) {
            logger.error((Object)"udb\u4ea7\u751f\u8ba4\u8bc1url\u4e0etoken\u5931\u8d25", (Throwable)e);
            Kits.writeJson((HttpServletResponse)response, (int)200, (CharSequence)"{\"success\":\"0\",\"errMsg\":\"UDB\u7edf\u4e00\u767b\u5f55\u5931\u8d25,\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\"}");
        }
    }

    public static void callback(HttpServletRequest request, HttpServletResponse response, String servletPathPrefix, String appid, String appkey, String homepage, Callback c) throws Exception {
        String[] uProfile;
        String oauthToken = Kits.readParam((HttpServletRequest)request, (String)"oauth_token", null);
        String oauthVerfier = Kits.readParam((HttpServletRequest)request, (String)"oauth_verifier", null);
        String isRemMe = Kits.readParam((HttpServletRequest)request, (String)"isRemMe", null);
        String tokenSecret = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"udboauthtmptokensec".equals(cookie.getName())) continue;
                tokenSecret = AESHelper.decrypt((String)cookie.getValue(), (String)appkey);
                break;
            }
        }
        if (StringKit.isEmpty(tokenSecret)) {
            response.addHeader("X-DUOWAN-UDB-ERROR", String.valueOf(602));
            c.sendError(response, 602, 602, "Timeout for udb session, please try again!");
            return;
        }
        if (StringKit.isEmpty((String)oauthToken)) {
            response.addHeader("X-DUOWAN-UDB-ERROR", String.valueOf(603));
            c.sendError(response, 603, 603, "Missing udb param oauthToken");
            return;
        }
        if (StringKit.isEmpty((String)oauthVerfier)) {
            response.addHeader("X-DUOWAN-UDB-ERROR", String.valueOf(604));
            c.sendError(response, 604, 604, "Missing udb param oauthVerfier");
            return;
        }
        BasicCredentials cc = new BasicCredentials(appid, appkey);
        UniversalLoginClient duowan = new UniversalLoginClient((Credentials)cc);
        String[] accessTokenInfo = duowan.getAccessToken(oauthToken, tokenSecret, oauthVerfier);
        String yyuid = duowan.getYyuid(accessTokenInfo[0]);
        if (!c.postUdbLogin(request, response, yyuid, uProfile = duowan.getUserProfile(accessTokenInfo[0]))) {
            response.addHeader("X-DUOWAN-UDB-ERROR", String.valueOf(605));
            c.sendError(response, 605, 605, "Invalid account!");
            return;
        }
        LinkedList<String> reqDomainList = new LinkedList<String>();
        reqDomainList.add("lgn.tuboshu.com");
        reqDomainList.add("lgn.yy.com");
        reqDomainList.add("lgn.yy.tv");
        reqDomainList.add("lgn.duowan.com");
        String writeCookieURL = duowan.getWriteCookieURL(accessTokenInfo[0], yyuid, reqDomainList);
        String url = StringKit.isNotEmpty((String)homepage) ? "document.location.protocol+'" + UdbKit.getRealUrl(request, null, servletPathPrefix, homepage) + "'" : "'" + Kits.readParam((HttpServletRequest)request, (String)PARAM_URL, (String)"/") + "'";
        StringBuilder sb = new StringBuilder(256).append("<script language=\"JavaScript\" type=\"text/javascript\">function udb_callback(){self.parent.UDB.sdk.PCWeb.writeCrossmainCookieWithCallBack('" + writeCookieURL + "',function(){self.parent.document.location.href=" + url + ";});};udb_callback();</script>").append("</head><body>");
        Kits.writeHtml((HttpServletResponse)response, (int)200, (CharSequence)sb);
    }

    public static void denyCallback(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuilder out = new StringBuilder(512);
        out.append("<!DOCTYPE html>");
        out.append("<html>");
        out.append("<head>");
        out.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />");
        out.append("<title>YY\u7edf\u4e00\u9a8c\u8bc1\u4e2d\u5fc3</title>");
        out.append("<script src=\"https://res.udb.duowan.com/js/jquery-1.4.2.min.js\" type=\"text/javascript\"></script>");
        out.append("<script type=\"text/javascript\" src=\"https://res.udb.duowan.com/lgn/js/oauth/udbsdk/pcweb/udb.sdk.pcweb.popup.min.js\"></script>");
        out.append("<script language=\"JavaScript\" type=\"text/javascript\">");
        out.append("self.parent.UDB.sdk.PCWeb.popupCloseLgn();");
        out.append("</script>");
        out.append("</head></html>");
        Kits.writeHtml((HttpServletResponse)response, (int)200, (CharSequence)out);
    }

    public static void logout(HttpServletRequest request, HttpServletResponse response, String servletPathPrefix, String appid, String appkey, String logoutpage, Callback c) throws IOException {
        c.preUdbLogout(request, response);
        String deleteCookieURL = YYSecCenterOpenWSInvoker.getOAuthCookieDeleteURL((String)appid, (String)appkey);
        StringBuilder sb = new StringBuilder(512);
        sb.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        sb.append("<html>");
        sb.append("<head>");
        sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        sb.append("<title>YY\u7edf\u4e00\u9a8c\u8bc1\u4e2d\u5fc3</title>");
        sb.append("<script src=\"https://res.udb.duowan.com/js/jquery-1.4.2.min.js\" type=\"text/javascript\"></script>");
        sb.append("<script src=\"https://res.udb.duowan.com/lgn/js/oauth/udbsdk/pcweb/udb.sdk.pcweb.popup.min.js\" type=\"text/javascript\"></script>");
        sb.append("</head>");
        sb.append("<script type=\"text/javascript\">");
        sb.append("function logout(){ UDB.sdk.PCWeb.deleteCrossmainCookieWithCallBack(\"" + deleteCookieURL + "\" ,");
        sb.append("\t function() { top.location.href = document.location.protocol+'");
        if (StringKit.isNotEmpty((String)logoutpage)) {
            sb.append(UdbKit.getRealUrl(request, null, servletPathPrefix, logoutpage));
        } else {
            sb.append(UdbKit.getRealUrl(request, null, servletPathPrefix, LOOKUP_PATH_LOGIN));
        }
        sb.append("' } ); }");
        sb.append("</script>");
        sb.append("<body onload=\"logout();\">");
        sb.append("</body>");
        sb.append("</html>");
        Kits.writeHtml((HttpServletResponse)response, (int)200, (CharSequence)sb);
    }

    public static String[] tryOssLogin(HttpServletRequest request, HttpServletResponse response, String appid, String appkey) throws IOException {
        UserinfoForOauth userinfoForOauth = new UserinfoForOauth(request, response, appid, appkey);
        if (userinfoForOauth.validate()) {
            String username = userinfoForOauth.getUsername();
            String yyuid = userinfoForOauth.getYyuid();
            return new String[]{username, yyuid};
        }
        return null;
    }

    public static interface Callback {
        public boolean postUdbLogin(HttpServletRequest var1, HttpServletResponse var2, String var3, String[] var4) throws IOException;

        public void preUdbLogout(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

        public Principal validateAndExtendPrincipal(Wsid var1) throws IOException;

        public void sendError(HttpServletResponse var1, int var2, int var3, String var4) throws IOException;
    }
}

