/*
 * Decompiled with CFR 0.152.
 */
package com.github.obase.webc.hiido;

import com.github.obase.MessageException;
import com.github.obase.WrappedException;
import com.github.obase.kit.CollectKit;
import com.github.obase.kit.StringKit;
import com.github.obase.security.Principal;
import com.github.obase.webc.yy.UserPrincipal;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import com.thetransactioncompany.jsonrpc2.client.JSONRPC2Session;
import com.thetransactioncompany.jsonrpc2.client.JSONRPC2SessionOptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class HiidoKit {
    static Log logger = LogFactory.getLog(HiidoKit.class);
    public static final String HIIDO_UDB_API = "http://udb.hiido.com/udbApi.php";
    public static final String HIIDO_LOGIN_URL = "https://portal.hiido.com";
    public static final String LOOKUP_PATH_POST_HIIDO_LOGIN = "/postHiidoLogin";
    public static final String PARAM_TOKEN = "token";
    static final Map<String, Boolean> INVALID;
    static final Map<String, Boolean> VALID;

    private HiidoKit() {
    }

    public static UserPrincipal getStaffInfoByToken(String udbApi, String agentId, byte[] agentPwdBytes, String publicKey, String token) {
        JSONObject result = HiidoKit.jsonrpc(udbApi, agentId, agentPwdBytes, publicKey, "getStaffInfoByToken", Arrays.asList(token));
        if (RpcKit.code(result) != 1) {
            return null;
        }
        JSONObject data = RpcKit.dataObject(result);
        String passport = RpcKit._String((Map<String, Object>)data, "passport", null);
        if (StringKit.isNotEmpty((String)passport)) {
            UserPrincipal principal = new UserPrincipal();
            principal.setPassport(passport);
            principal.setJobCode(RpcKit._String((Map<String, Object>)data, "job_code", null));
            principal.setEmail(RpcKit._String((Map<String, Object>)data, "email", null));
            principal.setRealname(RpcKit._String((Map<String, Object>)data, "realname", null));
            principal.setNickname(RpcKit._String((Map<String, Object>)data, "nickname", null));
            principal.setDeptname(RpcKit._String((Map<String, Object>)data, "deptname", null));
            return principal;
        }
        return null;
    }

    public static List<Principal> getMyAgentStaffInfo(String udbApi, String agentId, byte[] agentPwdBytes, String publicKey) {
        JSONObject result = HiidoKit.jsonrpc(udbApi, agentId, agentPwdBytes, publicKey, "getMyAgentStaffInfo", Arrays.asList(Collections.emptyList()));
        if (RpcKit.code(result) != 1) {
            throw new MessageException("WEBC_YYUDB", 135169, result.toJSONString());
        }
        LinkedList<Principal> staffs = new LinkedList<Principal>();
        JSONArray list = RpcKit.array(result, "data", "data");
        if (CollectKit.isNotEmpty((Collection)list)) {
            for (Object item : list) {
                Map data = (Map)item;
                String passport = RpcKit._String(data, "passport", null);
                if (!StringKit.isNotEmpty((String)passport)) continue;
                UserPrincipal principal = new UserPrincipal();
                principal.setPassport(passport);
                principal.setJobCode(RpcKit._String(data, "job_code", null));
                principal.setEmail(RpcKit._String(data, "email", null));
                principal.setRealname(RpcKit._String(data, "realname", null));
                principal.setNickname(RpcKit._String(data, "nickname", null));
                principal.setDeptname(RpcKit._String(data, "deptname", null));
                staffs.add(principal);
            }
        }
        return staffs;
    }

    public static void updateMyStaffAgentInfo(String udbApi, String agentId, byte[] agentPwdBytes, String publicKey, boolean valid, String ... users) {
        if (users == null || users.length == 0) {
            return;
        }
        HashMap<String, Map<String, Boolean>> map = new HashMap<String, Map<String, Boolean>>();
        for (String user : users) {
            map.put(user, valid ? VALID : INVALID);
        }
        JSONObject result = HiidoKit.jsonrpc(udbApi, agentId, agentPwdBytes, publicKey, "updateMyStaffAgentInfo", Arrays.asList(map));
        if (RpcKit.code(result) != 1) {
            throw new MessageException("WEBC_YYUDB", 135169, result.toJSONString());
        }
    }

    public static void updateMyStaffAgentInfo(String udbApi, String agentId, byte[] agentPwdBytes, String publicKey, Map<String, Boolean> users) {
        if (users == null || users.size() == 0) {
            return;
        }
        HashMap<String, Map<String, Boolean>> map = new HashMap<String, Map<String, Boolean>>(users.size());
        for (Map.Entry<String, Boolean> entry : users.entrySet()) {
            map.put(entry.getKey(), Boolean.TRUE.equals(entry.getValue()) ? VALID : INVALID);
        }
        JSONObject result = HiidoKit.jsonrpc(udbApi, agentId, agentPwdBytes, publicKey, "updateMyStaffAgentInfo", Arrays.asList(map));
        if (RpcKit.code(result) != 1) {
            throw new MessageException("WEBC_YYUDB", 135169, result.toJSONString());
        }
    }

    public static JSONObject jsonrpc(String udbApi, String agentId, byte[] agentPwdBytes, String publicKey, String method) {
        return HiidoKit.jsonrpc(udbApi, agentId, agentPwdBytes, publicKey, new JSONRPC2Request(method, null));
    }

    public static JSONObject jsonrpc(String udbApi, String agentId, byte[] agentPwdBytes, String publicKey, String method, List params) {
        return HiidoKit.jsonrpc(udbApi, agentId, agentPwdBytes, publicKey, new JSONRPC2Request(method, params, null));
    }

    public static JSONObject jsonrpc(String udbApi, String agentId, byte[] agentPwdBytes, String publicKey, String method, Map<String, Object> params) {
        return HiidoKit.jsonrpc(udbApi, agentId, agentPwdBytes, publicKey, new JSONRPC2Request(method, params, null));
    }

    public static String identityString(String timestamp, String agentId, byte[] agentPwdBytes, String publicKey) throws GeneralSecurityException, IOException {
        byte[] cipher = RSAUtils.encryptByPublicKey(agentPwdBytes, publicKey);
        String cipherText = Base64.encodeBase64String((byte[])cipher);
        String md5Text = DigestUtils.md5Hex((String)(agentId + timestamp + cipherText));
        String identityStr = Base64.encodeBase64String((byte[])(agentId + ";" + timestamp + ";" + cipherText + ";" + md5Text).getBytes());
        return identityStr;
    }

    public static String identityString(String timestamp, String agentId, byte[] agentPwdBytes, String publicKey, String dynamicKey) throws GeneralSecurityException, IOException {
        byte[] cipher = RSAUtils.encryptByPublicKey(agentPwdBytes, publicKey);
        String cipherText = Base64.encodeBase64String((byte[])cipher);
        String md5Text = DigestUtils.md5Hex((String)(agentId + timestamp + cipherText + dynamicKey));
        String identityStr = Base64.encodeBase64String((byte[])(agentId + ";" + timestamp + ";" + cipherText + ";" + dynamicKey + ";" + md5Text).getBytes());
        return identityStr;
    }

    public static JSONObject jsonrpc(String udbApi, String agentId, byte[] agentPwdBytes, String publicKey, JSONRPC2Request request) {
        try {
            JSONRPC2Session session = new JSONRPC2Session(new URL(udbApi));
            JSONRPC2SessionOptions options = session.getOptions();
            options.acceptCookies(true);
            options.trustAllCerts(true);
            long now = System.currentTimeMillis();
            JSONRPC2Request authReq = new JSONRPC2Request("authenticate", Arrays.asList(HiidoKit.identityString(String.valueOf(now), agentId, agentPwdBytes, publicKey)), (Object)0);
            JSONRPC2Response authResp = session.send(authReq);
            if (!authResp.indicatesSuccess()) {
                JSONRPC2Error error = authResp.getError();
                throw new MessageException("hiido.authenticate", error.getCode(), error.getMessage());
            }
            request.setID((Object)1);
            JSONRPC2Response response = session.send(request);
            if (!response.indicatesSuccess()) {
                JSONRPC2Error error = response.getError();
                throw new MessageException("hiido." + request.getMethod(), error.getCode(), error.getMessage());
            }
            return (JSONObject)response.getResult();
        }
        catch (Exception e) {
            throw new WrappedException((Throwable)e);
        }
    }

    static {
        HashMap<String, Boolean> map1 = new HashMap<String, Boolean>(2);
        map1.put("is_alive", true);
        map1.put("is_show", true);
        VALID = Collections.unmodifiableMap(map1);
        HashMap<String, Boolean> map2 = new HashMap<String, Boolean>(2);
        map2.put("is_alive", false);
        map2.put("is_show", false);
        INVALID = Collections.unmodifiableMap(map2);
    }

    public static final class RpcKit {
        public static int code(JSONObject result) {
            Number num = (Number)result.get((Object)"code");
            return num == null ? -1 : num.intValue();
        }

        public static String msg(JSONObject result) {
            return (String)result.get((Object)"msg");
        }

        public static JSONObject dataObject(JSONObject result) {
            Object data = result.get((Object)"data");
            return (JSONObject)data;
        }

        public static JSONArray dataArray(JSONObject result) {
            Object data = result.get((Object)"data");
            return (JSONArray)data;
        }

        public static JSONObject object(JSONObject result, String ... steps) {
            if (steps == null || steps.length == 0) {
                return result;
            }
            Object rt = result;
            for (int i = 0; i < steps.length && rt != null; rt = rt.get((Object)steps[i]), ++i) {
            }
            return rt;
        }

        public static JSONArray array(JSONObject result, String ... steps) {
            if (steps == null || steps.length == 0) {
                return null;
            }
            Object rt = result;
            for (int i = 0; i < steps.length && rt != null; rt = rt.get((Object)steps[i]), ++i) {
            }
            return (JSONArray)rt;
        }

        public static int _int(Map<String, Object> map, String key, int def) {
            Number rt = (Number)map.get(key);
            return rt == null ? def : rt.intValue();
        }

        public static String _String(Map<String, Object> map, String key, String def) {
            Object rt = map.get(key);
            return rt == null ? def : rt.toString();
        }
    }

    static class RSAUtils {
        public static final String KEY_ALGORITHM = "RSA";
        public static final String SIGNATURE_ALGORITHM = "MD5withRSA";
        private static final String PUBLIC_KEY = "RSAPublicKey";
        private static final String PRIVATE_KEY = "RSAPrivateKey";
        private static final int MAX_ENCRYPT_BLOCK = 117;
        private static final int MAX_DECRYPT_BLOCK = 128;

        RSAUtils() {
        }

        public static Map<String, Object> genKeyPair() throws Exception {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
            keyPairGen.initialize(1024);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
            RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
            HashMap<String, Object> keyMap = new HashMap<String, Object>(2);
            keyMap.put(PUBLIC_KEY, publicKey);
            keyMap.put(PRIVATE_KEY, privateKey);
            return keyMap;
        }

        public static String sign(byte[] data, String privateKey) throws Exception {
            byte[] keyBytes = Base64.decodeBase64((String)privateKey);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initSign(privateK);
            signature.update(data);
            return Base64.encodeBase64String((byte[])signature.sign());
        }

        public static boolean verify(byte[] data, String publicKey, String sign) throws Exception {
            byte[] keyBytes = Base64.decodeBase64((String)publicKey);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PublicKey publicK = keyFactory.generatePublic(keySpec);
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initVerify(publicK);
            signature.update(data);
            return signature.verify(Base64.decodeBase64((String)sign));
        }

        public static byte[] decryptByPrivateKey(byte[] encryptedData, String privateKey) throws Exception {
            byte[] keyBytes = Base64.decodeBase64((String)privateKey);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, privateK);
            int inputLen = encryptedData.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 128;
            }
            byte[] decryptedData = out.toByteArray();
            out.close();
            return decryptedData;
        }

        public static byte[] decryptByPublicKey(byte[] encryptedData, String publicKey) throws Exception {
            byte[] keyBytes = Base64.decodeBase64((String)publicKey);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PublicKey publicK = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, publicK);
            int inputLen = encryptedData.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 128;
            }
            byte[] decryptedData = out.toByteArray();
            out.close();
            return decryptedData;
        }

        public static byte[] encryptByPublicKey(byte[] data, String publicKey) throws GeneralSecurityException, IOException {
            byte[] keyBytes = Base64.decodeBase64((String)publicKey);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PublicKey publicK = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, publicK);
            int inputLen = data.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            byte[] encryptedData = out.toByteArray();
            out.close();
            return encryptedData;
        }

        public static byte[] encryptByPrivateKey(byte[] data, String privateKey) throws Exception {
            byte[] keyBytes = Base64.decodeBase64((String)privateKey);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, privateK);
            int inputLen = data.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            byte[] encryptedData = out.toByteArray();
            out.close();
            return encryptedData;
        }

        public static String getPrivateKey(Map<String, Object> keyMap) throws Exception {
            Key key = (Key)keyMap.get(PRIVATE_KEY);
            return Base64.encodeBase64String((byte[])key.getEncoded());
        }

        public static String getPublicKey(Map<String, Object> keyMap) throws Exception {
            Key key = (Key)keyMap.get(PUBLIC_KEY);
            return Base64.encodeBase64String((byte[])key.getEncoded());
        }
    }
}

