/*
 * Decompiled with CFR 0.152.
 */
package com.github.obase.webc.udb;

import com.github.obase.kit.StringKit;
import com.github.obase.security.Principal;
import com.github.obase.webc.Kits;
import com.github.obase.webc.ServletMethodHandler;
import com.github.obase.webc.ServletMethodObject;
import com.github.obase.webc.Wsid;
import com.github.obase.webc.config.WebcConfig;
import com.github.obase.webc.support.security.WsidServletMethodProcessor;
import com.github.obase.webc.udb.UdbKit;
import com.github.obase.webc.yy.UserPrincipal;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Response;
import redis.clients.jedis.Transaction;

public abstract class UdbauthServletMethodProcessor
extends WsidServletMethodProcessor
implements UdbKit.Callback {
    protected abstract String getAppid();

    protected abstract String getAppkey();

    protected abstract String getHomepage();

    protected abstract String getLogoutpage();

    protected abstract JedisPool getJedisPool();

    public void setup(WebcConfig.FilterInitParam params, Map<String, ServletMethodObject> rules) throws ServletException {
        ServletMethodHandler loginObject = new ServletMethodHandler(){

            public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
                UdbKit.login(request, response, Kits.getNamespace((ServletRequest)request));
            }
        };
        ServletMethodHandler genUrlTokenObject = new ServletMethodHandler(){

            public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
                UdbKit.genUrlToken(request, response, Kits.getNamespace((ServletRequest)request), UdbauthServletMethodProcessor.this.getAppid(), UdbauthServletMethodProcessor.this.getAppkey());
            }
        };
        ServletMethodHandler callbackObject = new ServletMethodHandler(){

            public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
                UdbKit.callback(request, response, Kits.getNamespace((ServletRequest)request), UdbauthServletMethodProcessor.this.getAppid(), UdbauthServletMethodProcessor.this.getAppkey(), UdbauthServletMethodProcessor.this.getHomepage(), UdbauthServletMethodProcessor.this);
            }
        };
        ServletMethodHandler denyCallbackObject = new ServletMethodHandler(){

            public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
                UdbKit.denyCallback(request, response);
            }
        };
        ServletMethodHandler logoutObject = new ServletMethodHandler(){

            public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
                UdbKit.logout(request, response, Kits.getNamespace((ServletRequest)request), UdbauthServletMethodProcessor.this.getAppid(), UdbauthServletMethodProcessor.this.getAppkey(), UdbauthServletMethodProcessor.this.getLogoutpage(), UdbauthServletMethodProcessor.this);
            }
        };
        rules.put("/login", this.newServletMethodObject("/login", loginObject));
        rules.put("/genUrlToken", this.newServletMethodObject("/genUrlToken", genUrlTokenObject));
        rules.put("/callback", this.newServletMethodObject("/callback", callbackObject));
        rules.put("/denyCallback", this.newServletMethodObject("/denyCallback", denyCallbackObject));
        rules.put("/logout", this.newServletMethodObject("/logout", logoutObject));
        super.setup(params, rules);
    }

    private ServletMethodObject newServletMethodObject(String lookupPath, ServletMethodHandler handler) {
        ServletMethodObject object = new ServletMethodObject(null, lookupPath);
        Arrays.fill(object.handlers, handler);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal validateAndExtendPrincipal(Wsid wsid) {
        String data = null;
        try (Jedis jedis = null;){
            jedis = this.getJedisPool().getResource();
            Transaction tx = jedis.multi();
            Response resp = tx.get(wsid.id);
            tx.pexpire(wsid.id, this.timeoutMillis);
            tx.exec();
            data = (String)resp.get();
        }
        if (data != null) {
            return this.activatePrincipal(data);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean postUdbLogin(HttpServletRequest request, HttpServletResponse response, String yyuid, String[] uProfile) throws IOException {
        Principal principal = this.validatePrincipal(yyuid, uProfile);
        if (principal == null) {
            return false;
        }
        Wsid wsid = Wsid.valueOf((String)principal.key()).resetToken((long)this.wsidTokenBase);
        String data = this.persistPrincipal(principal);
        try (Jedis jedis = null;){
            jedis = this.getJedisPool().getResource();
            jedis.psetex(wsid.id, this.timeoutMillis, data);
        }
        request.setAttribute("$_WSID", (Object)wsid);
        request.setAttribute("$_PRINCIPAL", (Object)principal);
        Kits.writeCookie((HttpServletResponse)response, (String)"wsid", (String)Wsid.encode((Wsid)wsid), (String)this.wsidDomain, (String)"/", (int)-1);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preUdbLogout(HttpServletRequest request, HttpServletResponse response) {
        Wsid wsid = Kits.getWsid((ServletRequest)request);
        if (wsid == null) {
            wsid = Wsid.decode((String)Kits.readCookie((HttpServletRequest)request, (String)"wsid"));
        }
        if (wsid != null) {
            try (Jedis jedis = null;){
                jedis = this.getJedisPool().getResource();
                jedis.del(wsid.id.getBytes());
            }
        }
        Kits.writeCookie((HttpServletResponse)response, (String)"wsid", (String)"", (String)this.wsidDomain, (String)"/", (int)0);
    }

    protected void redirectLoginPage(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        StringBuilder psb = new StringBuilder(256);
        psb.append(request.getContextPath()).append(request.getServletPath());
        String queryString = request.getQueryString();
        if (StringKit.isNotEmpty((String)queryString)) {
            psb.append('?').append(queryString);
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append(Kits.getServletPath((HttpServletRequest)request, (String)"/login"));
        sb.append("?").append("url").append("=").append(URLEncoder.encode(psb.toString(), "UTF-8"));
        Kits.sendRedirect((HttpServletResponse)response, (String)sb.toString());
    }

    protected String persistPrincipal(Principal principal) {
        return ((UserPrincipal)principal).encode();
    }

    public Principal activatePrincipal(String data) {
        return new UserPrincipal().decode(data);
    }

    protected Principal validatePrincipal(String yyuid, String[] uProfile) {
        UserPrincipal principal = new UserPrincipal();
        principal.setYyuid(yyuid);
        principal.setPassport(uProfile[0]);
        principal.setRealname(uProfile[0]);
        return principal;
    }

    protected Principal validatePermission(Principal principal, HttpMethod method, ServletMethodObject object) {
        return principal;
    }
}

