/*
 * Decompiled with CFR 0.152.
 */
package com.github.omarmiatello.kotlinscripttoolbox.twitter;

import com.github.omarmiatello.kotlinscripttoolbox.core.BaseScope;
import com.github.omarmiatello.kotlinscripttoolbox.core.KotlinScriptToolboxScope;
import com.github.omarmiatello.kotlinscripttoolbox.core.Messages;
import com.github.omarmiatello.kotlinscripttoolbox.gson.GsonUtilsKt;
import com.github.omarmiatello.kotlinscripttoolbox.twitter.TweetDeleteData;
import com.github.omarmiatello.kotlinscripttoolbox.twitter.TweetDeleteResponse;
import com.github.omarmiatello.kotlinscripttoolbox.twitter.TweetMessageData;
import com.github.omarmiatello.kotlinscripttoolbox.twitter.TweetMessageRequest;
import com.github.omarmiatello.kotlinscripttoolbox.twitter.TweetMessageResponse;
import com.github.omarmiatello.kotlinscripttoolbox.twitter.TwitterScope;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\bf\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dJ\u0019\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJK\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00072\u001c\b\u0002\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J7\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u001c\b\u0002\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019JG\u0010\u0016\u001a\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u001b2\b\b\u0002\u0010\u0010\u001a\u00020\u00072\u001c\b\u0002\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Lcom/github/omarmiatello/kotlinscripttoolbox/twitter/TwitterScope;", "Lcom/github/omarmiatello/kotlinscripttoolbox/core/KotlinScriptToolboxScope;", "twitterHttpClient", "Lokhttp3/OkHttpClient;", "getTwitterHttpClient", "()Lokhttp3/OkHttpClient;", "deleteTweet", "", "id", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendTweet", "", "text", "maxMessages", "", "ignoreLimit", "request", "Lkotlin/Function2;", "Lcom/github/omarmiatello/kotlinscripttoolbox/twitter/TweetMessageResponse;", "Lcom/github/omarmiatello/kotlinscripttoolbox/twitter/TweetMessageRequest;", "(Ljava/lang/String;IZLkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendTweets", "messages", "Lcom/github/omarmiatello/kotlinscripttoolbox/core/Messages;", "(Lcom/github/omarmiatello/kotlinscripttoolbox/core/Messages;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "texts", "", "(Ljava/util/List;ZLkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "twitter"})
public interface TwitterScope
extends KotlinScriptToolboxScope {
    @NotNull
    public static final Companion Companion = com.github.omarmiatello.kotlinscripttoolbox.twitter.TwitterScope$Companion.$$INSTANCE;
    public static final int MESSAGE_MAX_SIZE = 280;
    public static final int URL_MAX_SIZE = 23;

    @NotNull
    public OkHttpClient getTwitterHttpClient();

    @Nullable
    public Object sendTweets(@NotNull List<String> var1, boolean var2, @NotNull Function2<? super String, ? super TweetMessageResponse, TweetMessageRequest> var3, @NotNull Continuation<? super Unit> var4);

    @Nullable
    public Object sendTweet(@NotNull String var1, int var2, boolean var3, @NotNull Function2<? super String, ? super TweetMessageResponse, TweetMessageRequest> var4, @NotNull Continuation<? super Unit> var5);

    @Nullable
    public Object sendTweets(@NotNull Messages var1, @NotNull Function2<? super String, ? super TweetMessageResponse, TweetMessageRequest> var2, @NotNull Continuation<? super Unit> var3);

    @Nullable
    public Object deleteTweet(@NotNull String var1, @NotNull Continuation<? super Boolean> var2);

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000bJ&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/omarmiatello/kotlinscripttoolbox/twitter/TwitterScope$Companion;", "", "()V", "MESSAGE_MAX_SIZE", "", "URL_MAX_SIZE", "from", "Lcom/github/omarmiatello/kotlinscripttoolbox/twitter/TwitterScope;", "baseScope", "Lcom/github/omarmiatello/kotlinscripttoolbox/core/BaseScope;", "consumerKey", "", "consumerSecret", "accessKey", "accessSecret", "twitter"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        public static final int MESSAGE_MAX_SIZE = 280;
        public static final int URL_MAX_SIZE = 23;

        private Companion() {
        }

        @NotNull
        public final TwitterScope from(@NotNull BaseScope baseScope, @NotNull String consumerKey, @NotNull String consumerSecret, @NotNull String accessKey, @NotNull String accessSecret) {
            Intrinsics.checkNotNullParameter((Object)baseScope, (String)"baseScope");
            Intrinsics.checkNotNullParameter((Object)consumerKey, (String)"consumerKey");
            Intrinsics.checkNotNullParameter((Object)consumerSecret, (String)"consumerSecret");
            Intrinsics.checkNotNullParameter((Object)accessKey, (String)"accessKey");
            Intrinsics.checkNotNullParameter((Object)accessSecret, (String)"accessSecret");
            return this.from(consumerKey, consumerSecret, accessKey, accessSecret);
        }

        public static /* synthetic */ TwitterScope from$default(Companion companion, BaseScope baseScope, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 2) != 0) {
                string = baseScope.readSystemProperty("TWITTER_CONSUMER_KEY");
            }
            if ((n & 4) != 0) {
                string2 = baseScope.readSystemProperty("TWITTER_CONSUMER_SECRET");
            }
            if ((n & 8) != 0) {
                string3 = baseScope.readSystemProperty("TWITTER_ACCESS_KEY");
            }
            if ((n & 0x10) != 0) {
                string4 = baseScope.readSystemProperty("TWITTER_ACCESS_SECRET");
            }
            return companion.from(baseScope, string, string2, string3, string4);
        }

        @NotNull
        public final TwitterScope from(@NotNull String consumerKey, @NotNull String consumerSecret, @NotNull String accessKey, @NotNull String accessSecret) {
            Intrinsics.checkNotNullParameter((Object)consumerKey, (String)"consumerKey");
            Intrinsics.checkNotNullParameter((Object)consumerSecret, (String)"consumerSecret");
            Intrinsics.checkNotNullParameter((Object)accessKey, (String)"accessKey");
            Intrinsics.checkNotNullParameter((Object)accessSecret, (String)"accessSecret");
            return new TwitterScope(consumerKey, accessKey, consumerSecret, accessSecret){
                @NotNull
                private final OkHttpClient twitterHttpClient;
                {
                    void this_$iv;
                    OkHttpClient.Builder builder = new OkHttpClient.Builder();
                    boolean bl = false;
                    this.twitterHttpClient = this_$iv.addInterceptor(new Interceptor($consumerKey, $accessKey, $consumerSecret, $accessSecret){
                        final /* synthetic */ String $consumerKey$inlined;
                        final /* synthetic */ String $accessKey$inlined;
                        final /* synthetic */ String $consumerSecret$inlined;
                        final /* synthetic */ String $accessSecret$inlined;
                        {
                            this.$consumerKey$inlined = string;
                            this.$accessKey$inlined = string2;
                            this.$consumerSecret$inlined = string3;
                            this.$accessSecret$inlined = string4;
                        }

                        @NotNull
                        public final Response intercept(@NotNull Interceptor.Chain chain) {
                            Mac mac;
                            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                            Interceptor.Chain chain2 = chain;
                            boolean bl = false;
                            Request request = chain2.request();
                            String string = UUID.randomUUID().toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
                            String nonce = string;
                            long timestamp = System.currentTimeMillis() / 1000L;
                            String urlEncoded = from.1.access$twitterHttpClient$lambda-2$encodeUtf8(request.url().toString());
                            String paramEncoded = from.1.access$twitterHttpClient$lambda-2$encodeUtf8("oauth_consumer_key=" + this.$consumerKey$inlined + "&oauth_nonce=" + nonce + "&oauth_signature_method=HMAC-SHA1&oauth_timestamp=" + timestamp + "&oauth_token=" + this.$accessKey$inlined + "&oauth_version=1.0");
                            Mac $this$twitterHttpClient_u24lambda_u2d2_u24lambda_u2d0 = mac = Mac.getInstance("HmacSHA1");
                            boolean bl2 = false;
                            byte[] byArray = (this.$consumerSecret$inlined + '&' + this.$accessSecret$inlined).getBytes(Charsets.UTF_8);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                            $this$twitterHttpClient_u24lambda_u2d2_u24lambda_u2d0.init(new SecretKeySpec(byArray, "HmacSHA1"));
                            byte[] byArray2 = (request.method() + '&' + urlEncoded + '&' + paramEncoded).getBytes(Charsets.UTF_8);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
                            byte[] it = mac.doFinal(byArray2);
                            boolean bl3 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            byte[] byArray3 = it;
                            String signature = from.1.access$twitterHttpClient$lambda-2$encodeUtf8(ByteString.Companion.of(Arrays.copyOf(byArray3, byArray3.length)).base64());
                            return chain2.proceed(request.newBuilder().addHeader("Authorization", "OAuth oauth_consumer_key=\"" + this.$consumerKey$inlined + "\", oauth_nonce=\"" + nonce + "\", oauth_signature=\"" + signature + "\", oauth_signature_method=\"HMAC-SHA1\", oauth_timestamp=\"" + timestamp + "\", oauth_token=\"" + this.$accessKey$inlined + "\", oauth_version=\"1.0\"").build());
                        }
                    }).build();
                }

                @NotNull
                public OkHttpClient getTwitterHttpClient() {
                    return this.twitterHttpClient;
                }

                @Nullable
                public Object sendTweets(@NotNull List<String> texts, boolean ignoreLimit, @NotNull Function2<? super String, ? super TweetMessageResponse, TweetMessageRequest> request, @NotNull Continuation<? super Unit> $completion) {
                    return DefaultImpls.sendTweets(this, texts, ignoreLimit, request, $completion);
                }

                @Nullable
                public Object sendTweets(@NotNull Messages messages, @NotNull Function2<? super String, ? super TweetMessageResponse, TweetMessageRequest> request, @NotNull Continuation<? super Unit> $completion) {
                    return DefaultImpls.sendTweets(this, messages, request, $completion);
                }

                @Nullable
                public Object sendTweet(@NotNull String text, int maxMessages, boolean ignoreLimit, @NotNull Function2<? super String, ? super TweetMessageResponse, TweetMessageRequest> request, @NotNull Continuation<? super Unit> $completion) {
                    return DefaultImpls.sendTweet(this, text, maxMessages, ignoreLimit, request, $completion);
                }

                @Nullable
                public Object deleteTweet(@NotNull String id, @NotNull Continuation<? super Boolean> $completion) {
                    return DefaultImpls.deleteTweet(this, id, $completion);
                }

                private static final String twitterHttpClient$lambda-2$encodeUtf8(String $this$twitterHttpClient_u24lambda_u2d2_u24encodeUtf8) {
                    String string = URLEncoder.encode($this$twitterHttpClient_u24lambda_u2d2_u24encodeUtf8, "UTF-8");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(this, \"UTF-8\")");
                    return StringsKt.replace$default((String)string, (String)"+", (String)"%2B", (boolean)false, (int)4, null);
                }

                public static final /* synthetic */ String access$twitterHttpClient$lambda-2$encodeUtf8(String $receiver) {
                    return from.1.twitterHttpClient$lambda-2$encodeUtf8($receiver);
                }
            };
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public static Object sendTweets(@NotNull TwitterScope $this, @NotNull List<String> texts, boolean ignoreLimit, @NotNull Function2<? super String, ? super TweetMessageResponse, TweetMessageRequest> request, @NotNull Continuation<? super Unit> $completion) {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Ref.ObjectRef lastTweet = new Ref.ObjectRef();
            Iterable iterable = texts;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ignoreLimit ? it : StringsKt.take((String)it, (int)280));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                Object item$iv$iv;
                String msg = (String)element$iv;
                boolean bl = false;
                System.out.println((Object)("\ud83d\udc23 --> " + msg));
                item$iv$iv = $this.getTwitterHttpClient().newCall(new Request.Builder().url("https://api.twitter.com/2/tweets").post(RequestBody.Companion.create(((TweetMessageRequest)request.invoke((Object)msg, lastTweet.element)).toString(), MediaType.Companion.get("application/json"))).build()).execute().body();
                String response = item$iv$iv != null ? item$iv$iv.string() : null;
                try {
                    void it;
                    String string = response;
                    Intrinsics.checkNotNull((Object)string);
                    Object $this$fromJson$iv = string;
                    boolean $i$f$fromJson22 = false;
                    $this$fromJson$iv = GsonUtilsKt.getGson().fromJson((String)$this$fromJson$iv, TweetMessageResponse.class);
                    TweetMessageResponse $i$f$fromJson22 = (TweetMessageResponse)$this$fromJson$iv;
                    Ref.ObjectRef objectRef = lastTweet;
                    boolean bl2 = false;
                    objectRef.element = Boxing.boxBoolean((((CharSequence)it.getData().getId()).length() > 0 ? 1 : 0) != 0) != false ? $this$fromJson$iv : null;
                }
                catch (Exception e) {
                    System.out.println((Object)("\u26a0\ufe0f Cannot parse " + response));
                }
                System.out.println((Object)("\ud83d\udc25 <-- id: " + ((object = (TweetMessageResponse)lastTweet.element) != null && (object = ((TweetMessageResponse)object).getData()) != null ? ((TweetMessageData)object).getId() : null) + ": " + response));
            }
            return Unit.INSTANCE;
        }

        public static /* synthetic */ Object sendTweets$default(TwitterScope twitterScope, List list, boolean bl, Function2 function2, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendTweets");
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                function2 = sendTweets.2.INSTANCE;
            }
            return twitterScope.sendTweets(list, bl, (Function2<? super String, ? super TweetMessageResponse, TweetMessageRequest>)function2, (Continuation<? super Unit>)continuation);
        }

        @Nullable
        public static Object sendTweet(@NotNull TwitterScope $this, @NotNull String text, int maxMessages, boolean ignoreLimit, @NotNull Function2<? super String, ? super TweetMessageResponse, TweetMessageRequest> request, @NotNull Continuation<? super Unit> $completion) {
            Object object = $this.sendTweets(CollectionsKt.take((Iterable)StringsKt.chunked((CharSequence)text, (int)280), (int)maxMessages), ignoreLimit, request, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        public static /* synthetic */ Object sendTweet$default(TwitterScope twitterScope, String string, int n, boolean bl, Function2 function2, Continuation continuation, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendTweet");
            }
            if ((n2 & 2) != 0) {
                n = 1;
            }
            if ((n2 & 4) != 0) {
                bl = false;
            }
            if ((n2 & 8) != 0) {
                function2 = sendTweet.2.INSTANCE;
            }
            return twitterScope.sendTweet(string, n, bl, (Function2<? super String, ? super TweetMessageResponse, TweetMessageRequest>)function2, (Continuation<? super Unit>)continuation);
        }

        @Nullable
        public static Object sendTweets(@NotNull TwitterScope $this, @NotNull Messages messages, @NotNull Function2<? super String, ? super TweetMessageResponse, TweetMessageRequest> request, @NotNull Continuation<? super Unit> $completion) {
            Object object = $this.sendTweets(messages.toStrings(280), true, request, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        public static /* synthetic */ Object sendTweets$default(TwitterScope twitterScope, Messages messages, Function2 function2, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendTweets");
            }
            if ((n & 2) != 0) {
                function2 = sendTweets.6.INSTANCE;
            }
            return twitterScope.sendTweets(messages, (Function2<? super String, ? super TweetMessageResponse, TweetMessageRequest>)function2, (Continuation<? super Unit>)continuation);
        }

        @Nullable
        public static Object deleteTweet(@NotNull TwitterScope $this, @NotNull String id, @NotNull Continuation<? super Boolean> $completion) {
            Object object;
            Object object2;
            System.out.println((Object)("\ud83d\udc80 --> DELETE " + id));
            ResponseBody responseBody = $this.getTwitterHttpClient().newCall(Request.Builder.delete$default((Request.Builder)new Request.Builder().url("https://api.twitter.com/2/tweets/" + id), null, (int)1, null).build()).execute().body();
            String response = responseBody != null ? responseBody.string() : null;
            try {
                String string = response;
                Intrinsics.checkNotNull((Object)string);
                String $this$fromJson$iv = string;
                boolean $i$f$fromJson = false;
                object2 = GsonUtilsKt.getGson().fromJson($this$fromJson$iv, TweetDeleteResponse.class);
                TweetDeleteResponse it = (TweetDeleteResponse)object2;
                boolean bl = false;
                object2 = (TweetDeleteResponse)(it.getData().getDeleted() ? object2 : null);
            }
            catch (Exception e) {
                System.out.println((Object)("\u26a0\ufe0f Cannot parse " + response));
                object2 = null;
            }
            Object res = object2;
            System.out.println((Object)("\u2620\ufe0f <-- DELETE " + id + "? " + ((object = res) != null && (object = ((TweetDeleteResponse)object).getData()) != null ? Boxing.boxBoolean((boolean)((TweetDeleteData)object).getDeleted()) : null) + ' ' + response));
            Object object3 = res;
            return Boxing.boxBoolean((boolean)(object3 != null && (object3 = ((TweetDeleteResponse)object3).getData()) != null ? ((TweetDeleteData)object3).getDeleted() : false));
        }
    }
}

