/*
 * Decompiled with CFR 0.152.
 */
package inrae.semantic_web.driver;

import inrae.semantic_web.ConfigurationObject;
import inrae.semantic_web.SWDiscoveryException;
import inrae.semantic_web.SWDiscoveryException$;
import inrae.semantic_web.driver.Rdf4jLocalRequestDriver;
import inrae.semantic_web.driver.Rdf4jSparqlRequestDriver;
import inrae.semantic_web.driver.RequestDriver;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.nativerdf.NativeStore;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class RequestDriverFactory$ {
    public static final RequestDriverFactory$ MODULE$ = new RequestDriverFactory$();
    private static File dataDir;
    private static SailRepository repository;
    private static Seq<RepositoryConnection> lCon;
    private static volatile byte bitmap$0;

    static {
        lCon = (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$);
        MODULE$.repository().init();
    }

    private File dataDir$lzycompute() {
        RequestDriverFactory$ requestDriverFactory$ = this;
        synchronized (requestDriverFactory$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                dataDir = Files.createTempDirectory("rdf4j-discovery", new FileAttribute[0]).toFile();
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return dataDir;
    }

    public File dataDir() {
        return (byte)(bitmap$0 & 1) == 0 ? this.dataDir$lzycompute() : dataDir;
    }

    private SailRepository repository$lzycompute() {
        RequestDriverFactory$ requestDriverFactory$ = this;
        synchronized (requestDriverFactory$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                repository = new SailRepository((Sail)new NativeStore(this.dataDir()));
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return repository;
    }

    public SailRepository repository() {
        return (byte)(bitmap$0 & 2) == 0 ? this.repository$lzycompute() : repository;
    }

    public Seq<RepositoryConnection> lCon() {
        return lCon;
    }

    public void lCon_$eq(Seq<RepositoryConnection> x$1) {
        lCon = x$1;
    }

    public void close() {
        this.lCon().foreach((Function1 & Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        this.repository().shutDown();
    }

    public RequestDriver build(ConfigurationObject.Source source) {
        Tuple2<RequestDriver, RepositoryConnection> r = this.build_withRepository(source, (Repository)this.repository());
        this.lCon_$eq((Seq<RepositoryConnection>)((Seq)this.lCon().$colon$plus(r._2())));
        return (RequestDriver)r._1();
    }

    public Tuple2<RequestDriver, RepositoryConnection> build_withRepository(ConfigurationObject.Source source, Repository repository) {
        Tuple2 tuple2;
        block28: {
            block27: {
                String string = source.mimetype();
                switch (string == null ? 0 : string.hashCode()) {
                    case -1417884249: {
                        if ("text/n3".equals(string)) {
                            break;
                        }
                        break block27;
                    }
                    case -1341058493: {
                        if (!"application/sparql-query".equals(string)) break block27;
                        String string2 = source.url();
                        String string3 = "";
                        if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block27;
                        Rdf4jSparqlRequestDriver r = new Rdf4jSparqlRequestDriver(source.id(), source.url(), source.login(), source.password(), source.token(), source.auth());
                        tuple2 = new Tuple2((Object)r, (Object)r.con());
                        break block28;
                    }
                    case -309045154: {
                        if ("text/turtle".equals(string)) {
                            break;
                        }
                        break block27;
                    }
                    case 1029613660: {
                        if ("text/rdf-xml".equals(string)) {
                            break;
                        }
                        break block27;
                    }
                    case 1969663169: {
                        if ("application/rdf+xml".equals(string)) {
                            break;
                        }
                        break block27;
                    }
                    default: {
                        break block27;
                    }
                }
                LazyRef con$lzy = new LazyRef();
                ConfigurationObject.Source source2 = source;
                String string4 = source.url();
                String string5 = "";
                if (string4 == null ? string5 != null : !string4.equals(string5)) {
                    Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> RequestDriverFactory$.con$1(con$lzy, repository).add(new URL(source.url()), source.url(), MODULE$.mimetypeToRdfFormat(source.mimetype()), new Resource[0]));
                    if (!(try_ instanceof Success)) {
                        if (try_ instanceof Failure) {
                            Failure failure = (Failure)try_;
                            Throwable e = failure.exception();
                            throw new SWDiscoveryException(e.getMessage(), SWDiscoveryException$.MODULE$.apply$default$2());
                        }
                        throw new MatchError((Object)try_);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    String string6 = source.file();
                    String string7 = "";
                    if ((string6 == null ? string7 != null : !string6.equals(string7)) && (source.file().startsWith("http://") || source.file().startsWith("https://"))) {
                        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> RequestDriverFactory$.con$1(con$lzy, repository).add(new URL(source.file()), source.file(), MODULE$.mimetypeToRdfFormat(source.mimetype()), new Resource[0]));
                        if (!(try_ instanceof Success)) {
                            if (try_ instanceof Failure) {
                                Failure failure = (Failure)try_;
                                Throwable e = failure.exception();
                                throw new SWDiscoveryException(e.getMessage(), SWDiscoveryException$.MODULE$.apply$default$2());
                            }
                            throw new MatchError((Object)try_);
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        String string8 = source.file();
                        String string9 = "";
                        if (string8 == null ? string9 != null : !string8.equals(string9)) {
                            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> RequestDriverFactory$.con$1(con$lzy, repository).add(new File(source.file()), source.file(), MODULE$.mimetypeToRdfFormat(source.mimetype()), new Resource[0]));
                            if (!(try_ instanceof Success)) {
                                if (try_ instanceof Failure) {
                                    Failure failure = (Failure)try_;
                                    Throwable e = failure.exception();
                                    throw new SWDiscoveryException(e.getMessage(), SWDiscoveryException$.MODULE$.apply$default$2());
                                }
                                throw new MatchError((Object)try_);
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                        } else {
                            String string10 = source.content();
                            String string11 = "";
                            if (string10 == null ? string11 != null : !string10.equals(string11)) {
                                ByteArrayInputStream targetStream = new ByteArrayInputStream(source.content().getBytes(StandardCharsets.UTF_8.name()));
                                Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> RequestDriverFactory$.con$1(con$lzy, repository).add((InputStream)targetStream, new StringBuilder(13).append("http://").append(source.id()).append("/graph").toString(), MODULE$.mimetypeToRdfFormat(source.mimetype()), new Resource[0]));
                                if (!(try_ instanceof Success)) {
                                    if (try_ instanceof Failure) {
                                        Failure failure = (Failure)try_;
                                        Throwable e = failure.exception();
                                        throw new SWDiscoveryException(e.getMessage(), SWDiscoveryException$.MODULE$.apply$default$2());
                                    }
                                    throw new MatchError((Object)try_);
                                }
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                            } else {
                                throw new SWDiscoveryException(new StringBuilder(40).append("Bad definition of source configuration :").append(source.toString()).toString(), SWDiscoveryException$.MODULE$.apply$default$2());
                            }
                        }
                    }
                }
                tuple2 = new Tuple2((Object)new Rdf4jLocalRequestDriver(RequestDriverFactory$.con$1(con$lzy, repository)), (Object)RequestDriverFactory$.con$1(con$lzy, repository));
                break block28;
            }
            throw new SWDiscoveryException(new StringBuilder(40).append("Bad definition of source configuration :").append(source.toString()).toString(), SWDiscoveryException$.MODULE$.apply$default$2());
        }
        return tuple2;
    }

    public RDFFormat mimetypeToRdfFormat(String mimetype) {
        RDFFormat rDFFormat;
        block5: {
            String string = mimetype;
            switch (string == null ? 0 : string.hashCode()) {
                case -1417884249: {
                    if (!"text/n3".equals(string)) break;
                    rDFFormat = RDFFormat.N3;
                    break block5;
                }
                case -309045154: {
                    if (!"text/turtle".equals(string)) break;
                    rDFFormat = RDFFormat.TURTLE;
                    break block5;
                }
                case 1029613660: {
                    if (!"text/rdf-xml".equals(string)) break;
                    rDFFormat = RDFFormat.RDFXML;
                    break block5;
                }
            }
            throw new SWDiscoveryException(new StringBuilder(31).append(mimetype).append(" : this format is not supported").toString(), SWDiscoveryException$.MODULE$.apply$default$2());
        }
        return rDFFormat;
    }

    private static final /* synthetic */ RepositoryConnection con$lzycompute$1(LazyRef con$lzy$1, Repository repository$1) {
        RepositoryConnection repositoryConnection;
        LazyRef lazyRef = con$lzy$1;
        synchronized (lazyRef) {
            repositoryConnection = con$lzy$1.initialized() ? (RepositoryConnection)con$lzy$1.value() : (RepositoryConnection)con$lzy$1.initialize((Object)repository$1.getConnection());
        }
        return repositoryConnection;
    }

    private static final RepositoryConnection con$1(LazyRef con$lzy$1, Repository repository$1) {
        return con$lzy$1.initialized() ? (RepositoryConnection)con$lzy$1.value() : RequestDriverFactory$.con$lzycompute$1(con$lzy$1, repository$1);
    }

    private RequestDriverFactory$() {
    }
}

