/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.db4j;

import com.github.paganini2008.devtools.db4j.JdbcType;
import com.github.paganini2008.devtools.jdbc.PreparedStatementCallback;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Db4jUtils {
    private static final Map<String, Type> classNamesAndJavaTypes = new HashMap<String, Type>();

    public static void mappingClassNameAndJavaType(String className, Type javaType) {
        classNamesAndJavaTypes.put(className, javaType);
    }

    public static Map<String, Type> getClassNamesAndJavaTypes() {
        return classNamesAndJavaTypes;
    }

    public static PreparedStatementCallback batchPrepare(List<Object[]> parameterList, int[] jdbcTypes) {
        return new BatchArgumentJdbcTypePreparedStatementCallback(parameterList, jdbcTypes);
    }

    public static PreparedStatementCallback batchPrepare(List<Object[]> parameterList, JdbcType[] jdbcTypes) {
        return new BatchArgumentJdbcTypePreparedStatementCallback(parameterList, jdbcTypes);
    }

    public static PreparedStatementCallback batchPrepare(List<Object[]> parameterList) {
        return new BatchArgumentPreparedStatementCallback(parameterList);
    }

    public static PreparedStatementCallback prepare(Object[] parameters) {
        return new ArgumentPreparedStatementCallback(parameters);
    }

    public static PreparedStatementCallback prepare(Object[] parameters, int[] jdbcTypes) {
        return new ArgumentJdbcTypePreparedStatementCallback(parameters, jdbcTypes);
    }

    public static PreparedStatementCallback prepare(Object[] parameters, JdbcType[] jdbcTypes) {
        return new ArgumentJdbcTypePreparedStatementCallback(parameters, jdbcTypes);
    }

    private static int[] getSqlTypes(JdbcType[] jdbcTypes) {
        int[] sqlTypes = new int[jdbcTypes.length];
        for (int i = 0; i < sqlTypes.length; ++i) {
            sqlTypes[i] = jdbcTypes[i].getTypeCode();
        }
        return sqlTypes;
    }

    static {
        classNamesAndJavaTypes.put(Byte.class.getName(), (Type)((Object)Byte.class));
        classNamesAndJavaTypes.put(Short.class.getName(), (Type)((Object)Short.class));
        classNamesAndJavaTypes.put(Integer.class.getName(), (Type)((Object)Integer.class));
        classNamesAndJavaTypes.put(Long.class.getName(), (Type)((Object)Long.class));
        classNamesAndJavaTypes.put(Float.class.getName(), (Type)((Object)Float.class));
        classNamesAndJavaTypes.put(Double.class.getName(), (Type)((Object)Double.class));
        classNamesAndJavaTypes.put(Character.class.getName(), (Type)((Object)Character.class));
        classNamesAndJavaTypes.put(Boolean.class.getName(), (Type)((Object)Boolean.class));
        classNamesAndJavaTypes.put(Byte.TYPE.getName(), Byte.TYPE);
        classNamesAndJavaTypes.put(Short.TYPE.getName(), Short.TYPE);
        classNamesAndJavaTypes.put(Integer.TYPE.getName(), Integer.TYPE);
        classNamesAndJavaTypes.put(Long.TYPE.getName(), Long.TYPE);
        classNamesAndJavaTypes.put(Float.TYPE.getName(), Float.TYPE);
        classNamesAndJavaTypes.put(Double.TYPE.getName(), Double.TYPE);
        classNamesAndJavaTypes.put(Character.TYPE.getName(), Character.TYPE);
        classNamesAndJavaTypes.put(Boolean.TYPE.getName(), Boolean.TYPE);
        classNamesAndJavaTypes.put(BigDecimal.class.getName(), (Type)((Object)BigDecimal.class));
        classNamesAndJavaTypes.put(BigInteger.class.getName(), (Type)((Object)BigInteger.class));
        classNamesAndJavaTypes.put(String.class.getName(), (Type)((Object)String.class));
        classNamesAndJavaTypes.put(Date.class.getName(), (Type)((Object)Date.class));
        classNamesAndJavaTypes.put(Time.class.getName(), (Type)((Object)Time.class));
        classNamesAndJavaTypes.put(Timestamp.class.getName(), (Type)((Object)Timestamp.class));
        classNamesAndJavaTypes.put(byte[].class.getName(), (Type)((Object)byte[].class));
    }

    private static class ArgumentJdbcTypePreparedStatementCallback
    implements PreparedStatementCallback {
        private final Object[] parameters;
        private final int[] sqlTypes;

        ArgumentJdbcTypePreparedStatementCallback(Object[] parameters, int[] sqlTypes) {
            this.parameters = parameters;
            this.sqlTypes = sqlTypes;
        }

        ArgumentJdbcTypePreparedStatementCallback(Object[] parameters, JdbcType[] jdbcTypes) {
            this(parameters, Db4jUtils.getSqlTypes(jdbcTypes));
        }

        public void setValues(PreparedStatement ps) throws SQLException {
            int rightLength;
            int leftLength = this.parameters != null ? this.parameters.length : 0;
            int n = rightLength = this.sqlTypes != null ? this.sqlTypes.length : 0;
            if (leftLength != rightLength) {
                throw new IllegalArgumentException("JdbcTypes'length doesn't matches parameters'length length.");
            }
            if (this.parameters != null && this.parameters.length > 0) {
                for (int i = 0; i < this.parameters.length; ++i) {
                    ps.setObject(i + 1, this.parameters[i]);
                }
            }
        }
    }

    private static class ArgumentPreparedStatementCallback
    implements PreparedStatementCallback {
        private final Object[] parameters;

        ArgumentPreparedStatementCallback(Object[] parameters) {
            this.parameters = parameters;
        }

        public void setValues(PreparedStatement ps) throws SQLException {
            if (this.parameters != null && this.parameters.length > 0) {
                for (int i = 0; i < this.parameters.length; ++i) {
                    ps.setObject(i + 1, this.parameters[i]);
                }
            }
        }
    }

    private static class BatchArgumentPreparedStatementCallback
    implements PreparedStatementCallback {
        private final List<Object[]> parameterList;

        BatchArgumentPreparedStatementCallback(List<Object[]> parameterList) {
            this.parameterList = parameterList;
        }

        public void setValues(PreparedStatement ps) throws SQLException {
            if (this.parameterList != null && this.parameterList.size() > 0) {
                for (Object[] parameters : this.parameterList) {
                    if (parameters == null || parameters.length <= 0) continue;
                    for (int i = 0; i < parameters.length; ++i) {
                        ps.setObject(i + 1, parameters[i]);
                    }
                    ps.addBatch();
                }
            }
        }
    }

    private static class BatchArgumentJdbcTypePreparedStatementCallback
    implements PreparedStatementCallback {
        private final List<Object[]> parameterList;
        private final int[] sqlTypes;

        BatchArgumentJdbcTypePreparedStatementCallback(List<Object[]> parameterList, int[] sqlTypes) {
            this.parameterList = parameterList;
            this.sqlTypes = sqlTypes;
        }

        BatchArgumentJdbcTypePreparedStatementCallback(List<Object[]> parameterList, JdbcType[] jdbcTypes) {
            this(parameterList, Db4jUtils.getSqlTypes(jdbcTypes));
        }

        public void setValues(PreparedStatement ps) throws SQLException {
            if (this.parameterList != null && this.parameterList.size() > 0) {
                for (Object[] parameters : this.parameterList) {
                    int rightLength;
                    int leftLength = parameters != null ? parameters.length : 0;
                    int n = rightLength = this.sqlTypes != null ? this.sqlTypes.length : 0;
                    if (leftLength != rightLength) {
                        throw new IllegalArgumentException("JdbcTypes'length doesn't matches parameters'length length.");
                    }
                    if (parameters == null || parameters.length <= 0) continue;
                    for (int i = 0; i < parameters.length; ++i) {
                        ps.setObject(i + 1, parameters[i]);
                    }
                    ps.addBatch();
                }
            }
        }
    }
}

