/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.db4j;

import com.github.paganini2008.devtools.collection.Tuple;
import com.github.paganini2008.devtools.db4j.ArraySqlParameter;
import com.github.paganini2008.devtools.db4j.ArraySqlParameters;
import com.github.paganini2008.devtools.db4j.Customizable;
import com.github.paganini2008.devtools.db4j.GeneratedKey;
import com.github.paganini2008.devtools.db4j.ResultSetExtractor;
import com.github.paganini2008.devtools.db4j.SqlParameter;
import com.github.paganini2008.devtools.db4j.SqlParameters;
import com.github.paganini2008.devtools.db4j.mapper.RowMapper;
import com.github.paganini2008.devtools.jdbc.Cursor;
import com.github.paganini2008.devtools.jdbc.DefaultPageableSql;
import com.github.paganini2008.devtools.jdbc.PageableQuery;
import com.github.paganini2008.devtools.jdbc.PageableSql;
import java.sql.SQLException;
import java.util.List;

public interface JdbcOperations {
    default public int update(String sql, Object[] args) throws SQLException {
        return this.update(sql, new ArraySqlParameter(args));
    }

    public int update(String var1, SqlParameter var2) throws SQLException;

    default public int update(String sql, Object[] args, GeneratedKey generatedKey) throws SQLException {
        return this.update(sql, new ArraySqlParameter(args), generatedKey);
    }

    public int update(String var1, SqlParameter var2, GeneratedKey var3) throws SQLException;

    default public int[] batchUpdate(String sql, List<Object[]> argsList) throws SQLException {
        return this.batchUpdate(sql, new ArraySqlParameters(argsList));
    }

    public int[] batchUpdate(String var1, SqlParameters var2) throws SQLException;

    default public <T> T query(String sql, Object[] args, ResultSetExtractor<T> extractor) throws SQLException {
        return this.query(sql, new ArraySqlParameter(args), extractor);
    }

    public <T> T query(String var1, SqlParameter var2, ResultSetExtractor<T> var3) throws SQLException;

    default public List<Tuple> queryForList(String sql, Object[] args) throws SQLException {
        return this.queryForList(sql, new ArraySqlParameter(args));
    }

    public List<Tuple> queryForList(String var1, SqlParameter var2) throws SQLException;

    default public <T> T queryForObject(String sql, Object[] args, RowMapper<T> rowMapper) throws SQLException {
        return this.queryForObject(sql, new ArraySqlParameter(args), rowMapper);
    }

    public <T> T queryForObject(String var1, SqlParameter var2, RowMapper<T> var3) throws SQLException;

    default public <T> List<T> queryForList(String sql, Object[] args, RowMapper<T> rowMapper) throws SQLException {
        return this.queryForList(sql, new ArraySqlParameter(args), rowMapper);
    }

    public <T> List<T> queryForList(String var1, SqlParameter var2, RowMapper<T> var3) throws SQLException;

    default public <T> Cursor<T> queryForCursor(String sql, Object[] args, RowMapper<T> rowMapper) throws SQLException {
        return this.queryForCursor(sql, new ArraySqlParameter(args), rowMapper);
    }

    public <T> Cursor<T> queryForCursor(String var1, SqlParameter var2, RowMapper<T> var3) throws SQLException;

    default public <T> Cursor<T> queryForCachedCursor(String sql, Object[] args, RowMapper<T> rowMapper) throws SQLException {
        return this.queryForCachedCursor(sql, new ArraySqlParameter(args), rowMapper);
    }

    public <T> Cursor<T> queryForCachedCursor(String var1, SqlParameter var2, RowMapper<T> var3) throws SQLException;

    default public PageableQuery<Tuple> queryForPage(String sql, Object[] args) throws SQLException {
        return this.queryForPage((PageableSql)new DefaultPageableSql(sql), (SqlParameter)new ArraySqlParameter(args));
    }

    default public PageableQuery<Tuple> queryForPage(String sql, SqlParameter sqlParameter) throws SQLException {
        return this.queryForPage((PageableSql)new DefaultPageableSql(sql), sqlParameter);
    }

    default public PageableQuery<Tuple> queryForPage(PageableSql pageableSql, Object[] args) throws SQLException {
        return this.queryForPage(pageableSql, (SqlParameter)new ArraySqlParameter(args));
    }

    public PageableQuery<Tuple> queryForPage(PageableSql var1, SqlParameter var2) throws SQLException;

    default public <T> PageableQuery<T> queryForPage(String sql, Object[] args, RowMapper<T> rowMapper) throws SQLException {
        return this.queryForPage((PageableSql)new DefaultPageableSql(sql), (SqlParameter)new ArraySqlParameter(args), rowMapper);
    }

    default public <T> PageableQuery<T> queryForPage(PageableSql pageableSql, Object[] args, RowMapper<T> rowMapper) throws SQLException {
        return this.queryForPage(pageableSql, (SqlParameter)new ArraySqlParameter(args), rowMapper);
    }

    default public <T> PageableQuery<T> queryForPage(String sql, SqlParameter sqlParameter, RowMapper<T> rowMapper) throws SQLException {
        return this.queryForPage((PageableSql)new DefaultPageableSql(sql), sqlParameter, rowMapper);
    }

    public <T> PageableQuery<T> queryForPage(PageableSql var1, SqlParameter var2, RowMapper<T> var3) throws SQLException;

    public <T> T customize(Customizable<T> var1) throws SQLException;
}

