/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.db4j;

import java.util.HashMap;
import java.util.Map;

public enum JdbcType {
    ARRAY(2003),
    BIT(-7),
    TINYINT(-6),
    SMALLINT(5),
    INTEGER(4),
    BIGINT(-5),
    FLOAT(6),
    REAL(7),
    DOUBLE(8),
    NUMERIC(2),
    DECIMAL(3),
    CHAR(1),
    VARCHAR(12),
    LONGVARCHAR(-1),
    DATE(91),
    TIME(92),
    TIMESTAMP(93),
    BINARY(-2),
    VARBINARY(-3),
    LONGVARBINARY(-4),
    NULL(0),
    OTHER(1111),
    BLOB(2004),
    CLOB(2005),
    BOOLEAN(16),
    NVARCHAR(-9),
    NCHAR(-15),
    NCLOB(2011),
    STRUCT(2002),
    ENUM(-2147482647),
    OBJECT(-2147482646);

    private final int typeCode;
    private static Map<Integer, JdbcType> jdbcTypes;

    private JdbcType(int typeCode) {
        this.typeCode = typeCode;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public static JdbcType find(int typeCode) {
        return jdbcTypes.get(typeCode);
    }

    static {
        jdbcTypes = new HashMap<Integer, JdbcType>();
        for (JdbcType type : JdbcType.values()) {
            jdbcTypes.put(type.typeCode, type);
        }
    }
}

