/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.db4j.mapper;

import com.github.paganini2008.devtools.beans.PropertyUtils;
import com.github.paganini2008.devtools.db4j.JdbcType;
import com.github.paganini2008.devtools.db4j.mapper.AbstractRowMapper;
import com.github.paganini2008.devtools.db4j.mapper.RowMapperException;
import com.github.paganini2008.devtools.reflection.ConstructorUtils;

public class BeanPropertyRowMapper<T>
extends AbstractRowMapper<T> {
    private final Class<T> elementType;

    public BeanPropertyRowMapper(Class<T> elementType) {
        this.elementType = elementType;
    }

    @Override
    protected T createObject(int columnCount) {
        try {
            return (T)ConstructorUtils.invokeConstructor(this.elementType, (Object[])null);
        }
        catch (Exception e) {
            throw new RowMapperException(e);
        }
    }

    @Override
    protected void setValue(T object, int columnIndex, String columnName, String columnDisplayName, JdbcType jdbcType, Object columnValue) {
        try {
            PropertyUtils.setProperty(object, (String)columnDisplayName, (Object)columnValue);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

