/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.db4j.type;

import com.github.paganini2008.devtools.converter.ConvertUtils;
import com.github.paganini2008.devtools.db4j.JdbcType;
import com.github.paganini2008.devtools.db4j.type.TypeHandler;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class BasicTypeHandler
implements TypeHandler {
    protected BasicTypeHandler() {
    }

    @Override
    public void setValue(PreparedStatement ps, int parameterIndex, Object parameter, JdbcType jdbcType) throws SQLException {
        if (parameter != null) {
            this.setNonNullValue(ps, parameterIndex, ConvertUtils.convertValue((Object)parameter, this.getJavaType()), jdbcType);
        } else {
            this.setNullValue(ps, parameterIndex, parameter, jdbcType);
        }
    }

    protected void setNullValue(PreparedStatement ps, int parameterIndex, Object parameter, JdbcType jdbcType) throws SQLException {
        if (jdbcType != JdbcType.OTHER || jdbcType != JdbcType.OBJECT) {
            ps.setNull(parameterIndex, jdbcType.getTypeCode());
        } else {
            ps.setObject(parameterIndex, null);
        }
    }

    @Override
    public Object getValue(ResultSet rs, String columnName) throws SQLException {
        Object result = this.getNullableValue(rs, columnName);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    @Override
    public Object getValue(ResultSet rs, int columnIndex) throws SQLException {
        Object result = this.getNullableValue(rs, columnIndex);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    @Override
    public Object getValue(CallableStatement cs, int columnIndex) throws SQLException {
        Object result = this.getNullableValue(cs, columnIndex);
        if (cs.wasNull()) {
            return null;
        }
        return result;
    }

    protected abstract void setNonNullValue(PreparedStatement var1, int var2, Object var3, JdbcType var4) throws SQLException;

    protected abstract Object getNullableValue(ResultSet var1, String var2) throws SQLException;

    protected abstract Object getNullableValue(ResultSet var1, int var2) throws SQLException;

    protected abstract Object getNullableValue(CallableStatement var1, int var2) throws SQLException;

    public abstract Class<?> getJavaType();
}

