/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.db4j.type;

import com.github.paganini2008.devtools.db4j.JdbcType;
import com.github.paganini2008.devtools.db4j.type.BasicTypeHandler;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BigIntegerTypeHandler
extends BasicTypeHandler {
    @Override
    protected void setNonNullValue(PreparedStatement ps, int parameterIndex, Object parameter, JdbcType jdbcType) throws SQLException {
        ps.setBigDecimal(parameterIndex, new BigDecimal(this.getJavaType().cast(parameter)));
    }

    @Override
    protected BigInteger getNullableValue(ResultSet rs, String columnName) throws SQLException {
        BigDecimal result = rs.getBigDecimal(columnName);
        return result != null ? result.toBigInteger() : null;
    }

    @Override
    protected BigInteger getNullableValue(ResultSet rs, int columnIndex) throws SQLException {
        BigDecimal result = rs.getBigDecimal(columnIndex);
        return result != null ? result.toBigInteger() : null;
    }

    @Override
    public BigInteger getNullableValue(CallableStatement cs, int columnIndex) throws SQLException {
        BigDecimal result = cs.getBigDecimal(columnIndex);
        return result != null ? result.toBigInteger() : null;
    }

    public Class<BigInteger> getJavaType() {
        return BigInteger.class;
    }
}

