/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.db4j.type;

import com.github.paganini2008.devtools.db4j.JdbcType;
import com.github.paganini2008.devtools.db4j.type.BasicTypeHandler;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class EnumTypeHandler<E extends Enum<E>>
extends BasicTypeHandler {
    private final Class<E> type;

    public EnumTypeHandler(Class<E> type) {
        this.type = type;
    }

    @Override
    protected void setNonNullValue(PreparedStatement ps, int parameterIndex, Object parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(parameterIndex, ((Enum)this.getJavaType().cast(parameter)).name());
    }

    @Override
    protected Enum<E> getNullableValue(ResultSet rs, String columnName) throws SQLException {
        String s = rs.getString(columnName);
        return s == null ? null : (Enum<E>)Enum.valueOf(this.type, s);
    }

    @Override
    protected Enum<E> getNullableValue(ResultSet rs, int columnIndex) throws SQLException {
        String s = rs.getString(columnIndex);
        return s == null ? null : (Enum<E>)Enum.valueOf(this.type, s);
    }

    public Class<E> getJavaType() {
        return this.type;
    }

    @Override
    protected Enum<E> getNullableValue(CallableStatement cs, int columnIndex) throws SQLException {
        String s = cs.getString(columnIndex);
        return s == null ? null : (Enum<E>)Enum.valueOf(this.type, s);
    }
}

